<?php
/**
 * Thim_Builder Video Popup config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Video_Popup' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Video_Popup extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Video constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'video-popup';
			self::$name = esc_html__( 'Thim: Video popup', 'coaching' );
			self::$desc = esc_html__( 'Display video youtube or vimeo.', 'coaching' );
			self::$icon = 'thim-widget-icon thim-widget-icon-video';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'value'       => '',
				),

				array(
					'type'        => 'textarea',
					'admin_label' => false,
					'heading'     => esc_html__( 'Description', 'coaching' ),
					'param_name'  => 'description',
					'std'         => esc_html__( 'Write a short description, that will describe the title or something informational and useful.', 'coaching' ),
				),
				array(
					'type'        => 'attach_image',
					'admin_label' => false,
					'heading'     => esc_html__( 'Image', 'coaching' ),
					'param_name'  => 'panel_image',
					'description' => esc_html__( 'Poster background display on popup video.', 'coaching' ),
				),
				array(
					'type'        => 'textfield',
					'admin_label' => false,
					'heading'     => esc_html__( 'URL Video', 'coaching' ),
					'param_name'  => 'url_video',
					'value'       => '',
				),
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
