<?php


function getbowtied_theme_register_required_plugins() {

    $plugins = array(
        'woocommerce' => array(
            'name'               => 'WooCommerce',
            'slug'               => 'woocommerce',
            'required'           => true,
        ),
        'the-retailer-extender' => array(
            'name'               => 'The Retailer Extender',
            'slug'               => 'the-retailer-extender',
            'source'             => 'https://getbowtied.github.io/repository/plugins/the-retailer-extender/the-retailer-extender.zip',
            'required'           => true,
            'external_url'       => 'https://1.envato.market/getbowtied-to-the-retailer'
        ),
        'kits-templates-and-patterns' => array(
            'name'               => 'Kits, Templates and Patterns',
            'slug'               => 'kits-templates-and-patterns',
            'required'           => true,
        ),
        'hookmeup'               => array(
            'name'               => 'HookMeUp – Unlock and use strategic spots in any WooCommerce Theme',
            'slug'               => 'hookmeup',
            'required'           => true,
        ),
        'product-blocks-for-woocommerce' => array(
          'name'               => 'Product Blocks for WooCommerce',
          'slug'               => 'product-blocks-for-woocommerce',
          'required'           => true,
        ),
        'js_composer' => array(
          'name'               => 'WPBakery Page Builder',
          'slug'               => 'js_composer',
          'source'             => 'https://getbowtied.github.io/repository/plugins/wp-bakery/js_composer.zip',
          'required'           => false,
          'external_url'       => '',
          'version'            => '8.6.1'
        )
    );

    $config = array(
        'id'               => 'getbowtied',
        'default_path'      => '',
        'parent_slug'       => 'getbowtied-dashboard',
        'menu'              => 'getbowtied-plugins',
        'capability'        => 'edit_theme_options',
        'has_notices'       => true,
        'is_automatic'      => true,
        //'message'             => '',
        'strings'      => array(
            'page_title'                      => __( 'Plugins', 'theretailer' ),
            'menu_title'                      => __( 'Plugins', 'theretailer' ),
        )
    );

    tgmpa( $plugins, $config );
}
add_action( 'tgmpa_register', 'getbowtied_theme_register_required_plugins' );
