<?php
/**
 * The Front Page template file.
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0.31
 */

get_header();

// If front-page is a static page
if ( get_option( 'show_on_front' ) == 'page' ) {

	// If Front Page Builder is enabled - display sections
	if ( tooth_fairy_is_on( tooth_fairy_get_theme_option( 'front_page_enabled', false ) ) ) {

		if ( have_posts() ) {
			the_post();
		}

		$tooth_fairy_sections = tooth_fairy_array_get_keys_by_value( tooth_fairy_get_theme_option( 'front_page_sections' ) );
		if ( is_array( $tooth_fairy_sections ) ) {
			foreach ( $tooth_fairy_sections as $tooth_fairy_section ) {
				get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'front-page/section', $tooth_fairy_section ), $tooth_fairy_section );
			}
		}

		// Else if this page is a blog archive
	} elseif ( is_page_template( 'blog.php' ) ) {
		get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'blog' ) );

		// Else - display a native page content
	} else {
		get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'page' ) );
	}

	// Else get the template 'index.php' to show posts
} else {
	get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'index' ) );
}

get_footer();
