<div class="front_page_section front_page_section_blog<?php
	$tooth_fairy_scheme = tooth_fairy_get_theme_option( 'front_page_blog_scheme' );
	if ( ! empty( $tooth_fairy_scheme ) && ! tooth_fairy_is_inherit( $tooth_fairy_scheme ) ) {
		echo ' scheme_' . esc_attr( $tooth_fairy_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( tooth_fairy_get_theme_option( 'front_page_blog_paddings' ) );
	if ( tooth_fairy_get_theme_option( 'front_page_blog_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$tooth_fairy_css      = '';
		$tooth_fairy_bg_image = tooth_fairy_get_theme_option( 'front_page_blog_bg_image' );
		if ( ! empty( $tooth_fairy_bg_image ) ) {
			$tooth_fairy_css .= 'background-image: url(' . esc_url( tooth_fairy_get_attachment_url( $tooth_fairy_bg_image ) ) . ');';
		}
		if ( ! empty( $tooth_fairy_css ) ) {
			echo ' style="' . esc_attr( $tooth_fairy_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$tooth_fairy_anchor_icon = tooth_fairy_get_theme_option( 'front_page_blog_anchor_icon' );
	$tooth_fairy_anchor_text = tooth_fairy_get_theme_option( 'front_page_blog_anchor_text' );
if ( ( ! empty( $tooth_fairy_anchor_icon ) || ! empty( $tooth_fairy_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_blog"'
									. ( ! empty( $tooth_fairy_anchor_icon ) ? ' icon="' . esc_attr( $tooth_fairy_anchor_icon ) . '"' : '' )
									. ( ! empty( $tooth_fairy_anchor_text ) ? ' title="' . esc_attr( $tooth_fairy_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_blog_inner
	<?php
	if ( tooth_fairy_get_theme_option( 'front_page_blog_fullheight' ) ) {
		echo ' tooth-fairy-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$tooth_fairy_css      = '';
			$tooth_fairy_bg_mask  = tooth_fairy_get_theme_option( 'front_page_blog_bg_mask' );
			$tooth_fairy_bg_color_type = tooth_fairy_get_theme_option( 'front_page_blog_bg_color_type' );
			if ( 'custom' == $tooth_fairy_bg_color_type ) {
				$tooth_fairy_bg_color = tooth_fairy_get_theme_option( 'front_page_blog_bg_color' );
			} elseif ( 'scheme_bg_color' == $tooth_fairy_bg_color_type ) {
				$tooth_fairy_bg_color = tooth_fairy_get_scheme_color( 'bg_color', $tooth_fairy_scheme );
			} else {
				$tooth_fairy_bg_color = '';
			}
			if ( ! empty( $tooth_fairy_bg_color ) && $tooth_fairy_bg_mask > 0 ) {
				$tooth_fairy_css .= 'background-color: ' . esc_attr(
					1 == $tooth_fairy_bg_mask ? $tooth_fairy_bg_color : tooth_fairy_hex2rgba( $tooth_fairy_bg_color, $tooth_fairy_bg_mask )
				) . ';';
			}
			if ( ! empty( $tooth_fairy_css ) ) {
				echo ' style="' . esc_attr( $tooth_fairy_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_blog_content_wrap content_wrap">
			<?php
			// Caption
			$tooth_fairy_caption = tooth_fairy_get_theme_option( 'front_page_blog_caption' );
			if ( ! empty( $tooth_fairy_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_blog_caption front_page_block_<?php echo ! empty( $tooth_fairy_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $tooth_fairy_caption, 'tooth_fairy_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$tooth_fairy_description = tooth_fairy_get_theme_option( 'front_page_blog_description' );
			if ( ! empty( $tooth_fairy_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_blog_description front_page_block_<?php echo ! empty( $tooth_fairy_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $tooth_fairy_description ), 'tooth_fairy_kses_content' ); ?></div>
				<?php
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_blog_output">
				<?php
				if ( is_active_sidebar( 'front_page_blog_widgets' ) ) {
					dynamic_sidebar( 'front_page_blog_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! tooth_fairy_exists_trx_addons() ) {
						tooth_fairy_customizer_need_trx_addons_message();
					} else {
						tooth_fairy_customizer_need_widgets_message( 'front_page_blog_caption', 'ThemeREX Addons - Blogger' );
					}
				}
				?>
			</div>
		</div>
	</div>
</div>
