<div class="front_page_section front_page_section_googlemap<?php
	$tooth_fairy_scheme = tooth_fairy_get_theme_option( 'front_page_googlemap_scheme' );
	if ( ! empty( $tooth_fairy_scheme ) && ! tooth_fairy_is_inherit( $tooth_fairy_scheme ) ) {
		echo ' scheme_' . esc_attr( $tooth_fairy_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( tooth_fairy_get_theme_option( 'front_page_googlemap_paddings' ) );
	if ( tooth_fairy_get_theme_option( 'front_page_googlemap_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$tooth_fairy_css      = '';
		$tooth_fairy_bg_image = tooth_fairy_get_theme_option( 'front_page_googlemap_bg_image' );
		if ( ! empty( $tooth_fairy_bg_image ) ) {
			$tooth_fairy_css .= 'background-image: url(' . esc_url( tooth_fairy_get_attachment_url( $tooth_fairy_bg_image ) ) . ');';
		}
		if ( ! empty( $tooth_fairy_css ) ) {
			echo ' style="' . esc_attr( $tooth_fairy_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$tooth_fairy_anchor_icon = tooth_fairy_get_theme_option( 'front_page_googlemap_anchor_icon' );
	$tooth_fairy_anchor_text = tooth_fairy_get_theme_option( 'front_page_googlemap_anchor_text' );
if ( ( ! empty( $tooth_fairy_anchor_icon ) || ! empty( $tooth_fairy_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_googlemap"'
									. ( ! empty( $tooth_fairy_anchor_icon ) ? ' icon="' . esc_attr( $tooth_fairy_anchor_icon ) . '"' : '' )
									. ( ! empty( $tooth_fairy_anchor_text ) ? ' title="' . esc_attr( $tooth_fairy_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_googlemap_inner
		<?php
		$tooth_fairy_layout = tooth_fairy_get_theme_option( 'front_page_googlemap_layout' );
		echo ' front_page_section_layout_' . esc_attr( $tooth_fairy_layout );
		if ( tooth_fairy_get_theme_option( 'front_page_googlemap_fullheight' ) ) {
			echo ' tooth-fairy-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
		"
			<?php
			$tooth_fairy_css      = '';
			$tooth_fairy_bg_mask  = tooth_fairy_get_theme_option( 'front_page_googlemap_bg_mask' );
			$tooth_fairy_bg_color_type = tooth_fairy_get_theme_option( 'front_page_googlemap_bg_color_type' );
			if ( 'custom' == $tooth_fairy_bg_color_type ) {
				$tooth_fairy_bg_color = tooth_fairy_get_theme_option( 'front_page_googlemap_bg_color' );
			} elseif ( 'scheme_bg_color' == $tooth_fairy_bg_color_type ) {
				$tooth_fairy_bg_color = tooth_fairy_get_scheme_color( 'bg_color', $tooth_fairy_scheme );
			} else {
				$tooth_fairy_bg_color = '';
			}
			if ( ! empty( $tooth_fairy_bg_color ) && $tooth_fairy_bg_mask > 0 ) {
				$tooth_fairy_css .= 'background-color: ' . esc_attr(
					1 == $tooth_fairy_bg_mask ? $tooth_fairy_bg_color : tooth_fairy_hex2rgba( $tooth_fairy_bg_color, $tooth_fairy_bg_mask )
				) . ';';
			}
			if ( ! empty( $tooth_fairy_css ) ) {
				echo ' style="' . esc_attr( $tooth_fairy_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_googlemap_content_wrap
		<?php
		if ( 'fullwidth' != $tooth_fairy_layout ) {
			echo ' content_wrap';
		}
		?>
		">
			<?php
			// Content wrap with title and description
			$tooth_fairy_caption     = tooth_fairy_get_theme_option( 'front_page_googlemap_caption' );
			$tooth_fairy_description = tooth_fairy_get_theme_option( 'front_page_googlemap_description' );
			if ( ! empty( $tooth_fairy_caption ) || ! empty( $tooth_fairy_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'fullwidth' == $tooth_fairy_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}
					// Caption
				if ( ! empty( $tooth_fairy_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_googlemap_caption front_page_block_<?php echo ! empty( $tooth_fairy_caption ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $tooth_fairy_caption, 'tooth_fairy_kses_content' );
					?>
					</h2>
					<?php
				}

					// Description (text)
				if ( ! empty( $tooth_fairy_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_googlemap_description front_page_block_<?php echo ! empty( $tooth_fairy_description ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( wpautop( $tooth_fairy_description ), 'tooth_fairy_kses_content' );
					?>
					</div>
					<?php
				}
				if ( 'fullwidth' == $tooth_fairy_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$tooth_fairy_content = tooth_fairy_get_theme_option( 'front_page_googlemap_content' );
			if ( ! empty( $tooth_fairy_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'columns' == $tooth_fairy_layout ) {
					?>
					<div class="front_page_section_columns front_page_section_googlemap_columns columns_wrap">
						<div class="column-1_3">
					<?php
				} elseif ( 'fullwidth' == $tooth_fairy_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}

				?>
				<div class="front_page_section_content front_page_section_googlemap_content front_page_block_<?php echo ! empty( $tooth_fairy_content ) ? 'filled' : 'empty'; ?>">
				<?php
					echo wp_kses( $tooth_fairy_content, 'tooth_fairy_kses_content' );
				?>
				</div>
				<?php

				if ( 'columns' == $tooth_fairy_layout ) {
					?>
					</div><div class="column-2_3">
					<?php
				} elseif ( 'fullwidth' == $tooth_fairy_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Widgets output
			?>
			<div class="front_page_section_output front_page_section_googlemap_output">
				<?php
				if ( is_active_sidebar( 'front_page_googlemap_widgets' ) ) {
					dynamic_sidebar( 'front_page_googlemap_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! tooth_fairy_exists_trx_addons() ) {
						tooth_fairy_customizer_need_trx_addons_message();
					} else {
						tooth_fairy_customizer_need_widgets_message( 'front_page_googlemap_caption', 'ThemeREX Addons - Google map' );
					}
				}
				?>
			</div>
			<?php

			if ( 'columns' == $tooth_fairy_layout && ( ! empty( $tooth_fairy_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>
		</div>
	</div>
</div>
