<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */

$tooth_fairy_template = apply_filters( 'tooth_fairy_filter_get_template_part', tooth_fairy_blog_archive_get_template() );

if ( ! empty( $tooth_fairy_template ) && 'index' != $tooth_fairy_template ) {

	get_template_part( $tooth_fairy_template );

} else {

	tooth_fairy_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$tooth_fairy_stickies   = is_home()
								|| ( in_array( tooth_fairy_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) tooth_fairy_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$tooth_fairy_post_type  = tooth_fairy_get_theme_option( 'post_type' );
		$tooth_fairy_args       = array(
								'blog_style'     => tooth_fairy_get_theme_option( 'blog_style' ),
								'post_type'      => $tooth_fairy_post_type,
								'taxonomy'       => tooth_fairy_get_post_type_taxonomy( $tooth_fairy_post_type ),
								'parent_cat'     => tooth_fairy_get_theme_option( 'parent_cat' ),
								'posts_per_page' => tooth_fairy_get_theme_option( 'posts_per_page' ),
								'sticky'         => tooth_fairy_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $tooth_fairy_stickies )
															&& count( $tooth_fairy_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		tooth_fairy_blog_archive_start();

		do_action( 'tooth_fairy_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'tooth_fairy_action_before_page_author' );
			get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'tooth_fairy_action_after_page_author' );
		}

		if ( tooth_fairy_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'tooth_fairy_action_before_page_filters' );
			tooth_fairy_show_filters( $tooth_fairy_args );
			do_action( 'tooth_fairy_action_after_page_filters' );
		} else {
			do_action( 'tooth_fairy_action_before_page_posts' );
			tooth_fairy_show_posts( array_merge( $tooth_fairy_args, array( 'cat' => $tooth_fairy_args['parent_cat'] ) ) );
			do_action( 'tooth_fairy_action_after_page_posts' );
		}

		do_action( 'tooth_fairy_action_blog_archive_end' );

		tooth_fairy_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
