<?php
/* Booked Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'tooth_fairy_booked_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'tooth_fairy_booked_theme_setup9', 9 );
	function tooth_fairy_booked_theme_setup9() {
		if ( tooth_fairy_exists_booked() ) {
			add_action( 'wp_enqueue_scripts', 'tooth_fairy_booked_frontend_scripts', 1100 );
			add_action( 'trx_addons_action_load_scripts_front_booked', 'tooth_fairy_booked_frontend_scripts', 10, 1 );
			add_action( 'wp_enqueue_scripts', 'tooth_fairy_booked_frontend_scripts_responsive', 2000 );
			add_action( 'trx_addons_action_load_scripts_front_booked', 'tooth_fairy_booked_frontend_scripts_responsive', 10, 1 );
			add_filter( 'tooth_fairy_filter_merge_styles', 'tooth_fairy_booked_merge_styles' );
			add_filter( 'tooth_fairy_filter_merge_styles_responsive', 'tooth_fairy_booked_merge_styles_responsive' );
		}
		if ( is_admin() ) {
			add_filter( 'tooth_fairy_filter_tgmpa_required_plugins', 'tooth_fairy_booked_tgmpa_required_plugins' );
			add_filter( 'tooth_fairy_filter_theme_plugins', 'tooth_fairy_booked_theme_plugins' );
		}
	}
}


// Filter to add in the required plugins list
if ( ! function_exists( 'tooth_fairy_booked_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('tooth_fairy_filter_tgmpa_required_plugins',	'tooth_fairy_booked_tgmpa_required_plugins');
	function tooth_fairy_booked_tgmpa_required_plugins( $list = array() ) {
		if ( tooth_fairy_storage_isset( 'required_plugins', 'booked' ) && tooth_fairy_storage_get_array( 'required_plugins', 'booked', 'install' ) !== false && tooth_fairy_is_theme_activated() ) {
			$path = tooth_fairy_get_plugin_source_path( 'plugins/booked/booked.zip' );
			if ( ! empty( $path ) || tooth_fairy_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => tooth_fairy_storage_get_array( 'required_plugins', 'booked', 'title' ),
					'slug'     => 'booked',
					'source'   => ! empty( $path ) ? $path : 'upload://booked.zip',
					'version'  => '2.4.3.1',
					'required' => false,
				);
			}
		}
		return $list;
	}
}


// Filter theme-supported plugins list
if ( ! function_exists( 'tooth_fairy_booked_theme_plugins' ) ) {
	//Handler of the add_filter( 'tooth_fairy_filter_theme_plugins', 'tooth_fairy_booked_theme_plugins' );
	function tooth_fairy_booked_theme_plugins( $list = array() ) {
		return tooth_fairy_add_group_and_logo_to_slave( $list, 'booked', 'booked-' );
	}
}


// Check if plugin installed and activated
if ( ! function_exists( 'tooth_fairy_exists_booked' ) ) {
	function tooth_fairy_exists_booked() {
		return class_exists( 'booked_plugin' );
	}
}


// Return a relative path to the plugin styles depend the version
if ( ! function_exists( 'tooth_fairy_booked_get_styles_dir' ) ) {
	function tooth_fairy_booked_get_styles_dir( $file ) {
		$base_dir = 'plugins/booked/';
		return $base_dir
				. ( defined( 'BOOKED_VERSION' ) && version_compare( BOOKED_VERSION, '2.4', '<' ) && tooth_fairy_get_folder_dir( $base_dir . 'old' )
					? 'old/'
					: ''
					)
				. $file;
	}
}


// Enqueue styles for frontend
if ( ! function_exists( 'tooth_fairy_booked_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'tooth_fairy_booked_frontend_scripts', 1100 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_booked', 'tooth_fairy_booked_frontend_scripts', 10, 1 );
	function tooth_fairy_booked_frontend_scripts( $force = false ) {
		tooth_fairy_enqueue_optimized( 'booked', $force, array(
			'css' => array(
				'tooth-fairy-booked' => array( 'src' => tooth_fairy_booked_get_styles_dir( 'booked.css' ) ),
			)
		) );
	}
}


// Enqueue responsive styles for frontend
if ( ! function_exists( 'tooth_fairy_booked_frontend_scripts_responsive' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'tooth_fairy_booked_frontend_scripts_responsive', 2000 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_booked', 'tooth_fairy_booked_frontend_scripts_responsive', 10, 1 );
	function tooth_fairy_booked_frontend_scripts_responsive( $force = false ) {
		tooth_fairy_enqueue_optimized_responsive( 'booked', $force, array(
			'css' => array(
				'tooth-fairy-booked-responsive' => array( 'src' => tooth_fairy_booked_get_styles_dir( 'booked-responsive.css' ), 'media' => 'all' ),
			)
		) );
	}
}


// Merge custom styles
if ( ! function_exists( 'tooth_fairy_booked_merge_styles' ) ) {
	//Handler of the add_filter('tooth_fairy_filter_merge_styles', 'tooth_fairy_booked_merge_styles');
	function tooth_fairy_booked_merge_styles( $list ) {
		$list[ tooth_fairy_booked_get_styles_dir( 'booked.css' ) ] = false;
		return $list;
	}
}


// Merge responsive styles
if ( ! function_exists( 'tooth_fairy_booked_merge_styles_responsive' ) ) {
	//Handler of the add_filter('tooth_fairy_filter_merge_styles_responsive', 'tooth_fairy_booked_merge_styles_responsive');
	function tooth_fairy_booked_merge_styles_responsive( $list ) {
		$list[ tooth_fairy_booked_get_styles_dir( 'booked-responsive.css' ) ] = false;
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( tooth_fairy_exists_booked() ) {
	$tooth_fairy_fdir = tooth_fairy_get_file_dir( tooth_fairy_booked_get_styles_dir( 'booked-style.php' ) );
	if ( ! empty( $tooth_fairy_fdir ) ) {
		require_once $tooth_fairy_fdir;
	}
}
