<?php

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'tooth_fairy_advanced_popups_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'tooth_fairy_advanced_popups_theme_setup9', 9 );
    function tooth_fairy_advanced_popups_theme_setup9() {
        if ( is_admin() ) {
            add_filter( 'tooth_fairy_filter_tgmpa_required_plugins', 'tooth_fairy_advanced_popups_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'tooth_fairy_advanced_popups_tgmpa_required_plugins' ) ) {    
    function tooth_fairy_advanced_popups_tgmpa_required_plugins( $list = array() ) {
        if ( tooth_fairy_storage_isset( 'required_plugins', 'advanced-popups' ) && tooth_fairy_storage_get_array( 'required_plugins', 'advanced-popups', 'install' ) !== false ) {
            $list[] = array(
                'name'     => tooth_fairy_storage_get_array( 'required_plugins', 'advanced-popups', 'title' ),
                'slug'     => 'advanced-popups',
                'required' => false,
            );
        }
        return $list;
    }
}

// Check if plugin installed and activated
if ( ! function_exists( 'tooth_fairy_exists_advanced_popups' ) ) {
    function tooth_fairy_exists_advanced_popups() {
        return function_exists('adp_init');
    }
}
