<?php
/**
 * The template to display Admin notices
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0.1
 */

$tooth_fairy_theme_slug = get_option( 'template' );
$tooth_fairy_theme_obj  = wp_get_theme( $tooth_fairy_theme_slug );
?>
<div class="tooth_fairy_admin_notice tooth_fairy_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$tooth_fairy_theme_img = tooth_fairy_get_file_url( 'screenshot.jpg' );
	if ( '' != $tooth_fairy_theme_img ) {
		?>
		<div class="tooth_fairy_notice_image"><img src="<?php echo esc_url( $tooth_fairy_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'tooth-fairy' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="tooth_fairy_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'tooth-fairy' ),
				$tooth_fairy_theme_obj->get( 'Name' ) . ( TOOTH_FAIRY_THEME_FREE ? ' ' . __( 'Free', 'tooth-fairy' ) : '' ),
				$tooth_fairy_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="tooth_fairy_notice_text">
		<p class="tooth_fairy_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $tooth_fairy_theme_obj->description ) );
			?>
		</p>
		<p class="tooth_fairy_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'tooth-fairy' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="tooth_fairy_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=tooth_fairy_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'tooth-fairy' );
			?>
		</a>
	</div>
</div>
