<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0.50
 */

$tooth_fairy_template_args = get_query_var( 'tooth_fairy_template_args' );
if ( is_array( $tooth_fairy_template_args ) ) {
	$tooth_fairy_columns    = empty( $tooth_fairy_template_args['columns'] ) ? 2 : max( 1, $tooth_fairy_template_args['columns'] );
	$tooth_fairy_blog_style = array( $tooth_fairy_template_args['type'], $tooth_fairy_columns );
} else {
	$tooth_fairy_template_args = array();
	$tooth_fairy_blog_style = explode( '_', tooth_fairy_get_theme_option( 'blog_style' ) );
	$tooth_fairy_columns    = empty( $tooth_fairy_blog_style[1] ) ? 2 : max( 1, $tooth_fairy_blog_style[1] );
}
$tooth_fairy_blog_id       = tooth_fairy_get_custom_blog_id( join( '_', $tooth_fairy_blog_style ) );
$tooth_fairy_blog_style[0] = str_replace( 'blog-custom-', '', $tooth_fairy_blog_style[0] );
$tooth_fairy_expanded      = ! tooth_fairy_sidebar_present() && tooth_fairy_get_theme_option( 'expand_content' ) == 'expand';
$tooth_fairy_components    = ! empty( $tooth_fairy_template_args['meta_parts'] )
							? ( is_array( $tooth_fairy_template_args['meta_parts'] )
								? join( ',', $tooth_fairy_template_args['meta_parts'] )
								: $tooth_fairy_template_args['meta_parts']
								)
							: tooth_fairy_array_get_keys_by_value( tooth_fairy_get_theme_option( 'meta_parts' ) );
$tooth_fairy_post_format   = get_post_format();
$tooth_fairy_post_format   = empty( $tooth_fairy_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tooth_fairy_post_format );

$tooth_fairy_blog_meta     = tooth_fairy_get_custom_layout_meta( $tooth_fairy_blog_id );
$tooth_fairy_custom_style  = ! empty( $tooth_fairy_blog_meta['scripts_required'] ) ? $tooth_fairy_blog_meta['scripts_required'] : 'none';

if ( ! empty( $tooth_fairy_template_args['slider'] ) || $tooth_fairy_columns > 1 || ! tooth_fairy_is_off( $tooth_fairy_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $tooth_fairy_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( tooth_fairy_is_off( $tooth_fairy_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $tooth_fairy_custom_style ) ) . "-1_{$tooth_fairy_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $tooth_fairy_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $tooth_fairy_columns )
					. ' post_layout_' . esc_attr( $tooth_fairy_blog_style[0] )
					. ' post_layout_' . esc_attr( $tooth_fairy_blog_style[0] ) . '_' . esc_attr( $tooth_fairy_columns )
					. ( ! tooth_fairy_is_off( $tooth_fairy_custom_style )
						? ' post_layout_' . esc_attr( $tooth_fairy_custom_style )
							. ' post_layout_' . esc_attr( $tooth_fairy_custom_style ) . '_' . esc_attr( $tooth_fairy_columns )
						: ''
						)
		);
	tooth_fairy_add_blog_animation( $tooth_fairy_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'tooth_fairy_action_show_layout', $tooth_fairy_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $tooth_fairy_template_args['slider'] ) || $tooth_fairy_columns > 1 || ! tooth_fairy_is_off( $tooth_fairy_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
