<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */

$tooth_fairy_template_args = get_query_var( 'tooth_fairy_template_args' );
$tooth_fairy_columns = 1;
if ( is_array( $tooth_fairy_template_args ) ) {
	$tooth_fairy_columns    = empty( $tooth_fairy_template_args['columns'] ) ? 1 : max( 1, $tooth_fairy_template_args['columns'] );
	$tooth_fairy_blog_style = array( $tooth_fairy_template_args['type'], $tooth_fairy_columns );
	if ( ! empty( $tooth_fairy_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $tooth_fairy_columns > 1 ) {
	    $tooth_fairy_columns_class = tooth_fairy_get_column_class( 1, $tooth_fairy_columns, ! empty( $tooth_fairy_template_args['columns_tablet']) ? $tooth_fairy_template_args['columns_tablet'] : '', ! empty($tooth_fairy_template_args['columns_mobile']) ? $tooth_fairy_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $tooth_fairy_columns_class ); ?>">
		<?php
	}
} else {
	$tooth_fairy_template_args = array();
}
$tooth_fairy_expanded    = ! tooth_fairy_sidebar_present() && tooth_fairy_get_theme_option( 'expand_content' ) == 'expand';
$tooth_fairy_post_format = get_post_format();
$tooth_fairy_post_format = empty( $tooth_fairy_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tooth_fairy_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $tooth_fairy_post_format ) );
	tooth_fairy_add_blog_animation( $tooth_fairy_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$tooth_fairy_hover      = ! empty( $tooth_fairy_template_args['hover'] ) && ! tooth_fairy_is_inherit( $tooth_fairy_template_args['hover'] )
							? $tooth_fairy_template_args['hover']
							: tooth_fairy_get_theme_option( 'image_hover' );
	$tooth_fairy_components = ! empty( $tooth_fairy_template_args['meta_parts'] )
							? ( is_array( $tooth_fairy_template_args['meta_parts'] )
								? $tooth_fairy_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $tooth_fairy_template_args['meta_parts'] ) )
								)
							: tooth_fairy_array_get_keys_by_value( tooth_fairy_get_theme_option( 'meta_parts' ) );
	tooth_fairy_show_post_featured( apply_filters( 'tooth_fairy_filter_args_featured',
		array(
			'no_links'   => ! empty( $tooth_fairy_template_args['no_links'] ),
			'hover'      => $tooth_fairy_hover,
			'meta_parts' => $tooth_fairy_components,
			'thumb_size' => ! empty( $tooth_fairy_template_args['thumb_size'] )
							? $tooth_fairy_template_args['thumb_size']
							: tooth_fairy_get_thumb_size( strpos( tooth_fairy_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $tooth_fairy_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$tooth_fairy_template_args
	) );

	// Title and post meta
	$tooth_fairy_show_title = get_the_title() != '';
	$tooth_fairy_show_meta  = count( $tooth_fairy_components ) > 0 && ! in_array( $tooth_fairy_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $tooth_fairy_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'tooth_fairy_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'tooth_fairy_action_before_post_title' );
				if ( empty( $tooth_fairy_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'tooth_fairy_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'tooth_fairy_filter_show_blog_excerpt', empty( $tooth_fairy_template_args['hide_excerpt'] ) && tooth_fairy_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'tooth_fairy_filter_show_blog_meta', $tooth_fairy_show_meta, $tooth_fairy_components, 'excerpt' ) ) {
				if ( count( $tooth_fairy_components ) > 0 ) {
					do_action( 'tooth_fairy_action_before_post_meta' );
					tooth_fairy_show_post_meta(
						apply_filters(
							'tooth_fairy_filter_post_meta_args', array(
								'components' => join( ',', $tooth_fairy_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'tooth_fairy_action_after_post_meta' );
				}
			}

			if ( tooth_fairy_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'tooth_fairy_action_before_full_post_content' );
					the_content( '' );
					do_action( 'tooth_fairy_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'tooth-fairy' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'tooth-fairy' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				tooth_fairy_show_post_content( $tooth_fairy_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'tooth_fairy_filter_show_blog_readmore',  ! isset( $tooth_fairy_template_args['more_button'] ) || ! empty( $tooth_fairy_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $tooth_fairy_template_args['no_links'] ) ) {
					do_action( 'tooth_fairy_action_before_post_readmore' );
					if ( tooth_fairy_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						tooth_fairy_show_post_more_link( $tooth_fairy_template_args, '<p>', '</p>' );
					} else {
						tooth_fairy_show_post_comments_link( $tooth_fairy_template_args, '<p>', '</p>' );
					}
					do_action( 'tooth_fairy_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $tooth_fairy_template_args ) ) {
	if ( ! empty( $tooth_fairy_template_args['slider'] ) || $tooth_fairy_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
