<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */

$tooth_fairy_template_args = get_query_var( 'tooth_fairy_template_args' );
if ( is_array( $tooth_fairy_template_args ) ) {
	$tooth_fairy_columns    = empty( $tooth_fairy_template_args['columns'] ) ? 2 : max( 1, $tooth_fairy_template_args['columns'] );
	$tooth_fairy_blog_style = array( $tooth_fairy_template_args['type'], $tooth_fairy_columns );
    $tooth_fairy_columns_class = tooth_fairy_get_column_class( 1, $tooth_fairy_columns, ! empty( $tooth_fairy_template_args['columns_tablet']) ? $tooth_fairy_template_args['columns_tablet'] : '', ! empty($tooth_fairy_template_args['columns_mobile']) ? $tooth_fairy_template_args['columns_mobile'] : '' );
} else {
	$tooth_fairy_template_args = array();
	$tooth_fairy_blog_style = explode( '_', tooth_fairy_get_theme_option( 'blog_style' ) );
	$tooth_fairy_columns    = empty( $tooth_fairy_blog_style[1] ) ? 2 : max( 1, $tooth_fairy_blog_style[1] );
    $tooth_fairy_columns_class = tooth_fairy_get_column_class( 1, $tooth_fairy_columns );
}

$tooth_fairy_post_format = get_post_format();
$tooth_fairy_post_format = empty( $tooth_fairy_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tooth_fairy_post_format );

?><div class="
<?php
if ( ! empty( $tooth_fairy_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( tooth_fairy_is_blog_style_use_masonry( $tooth_fairy_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $tooth_fairy_columns ) : esc_attr( $tooth_fairy_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $tooth_fairy_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $tooth_fairy_columns )
		. ( 'portfolio' != $tooth_fairy_blog_style[0] ? ' ' . esc_attr( $tooth_fairy_blog_style[0] )  . '_' . esc_attr( $tooth_fairy_columns ) : '' )
	);
	tooth_fairy_add_blog_animation( $tooth_fairy_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$tooth_fairy_hover   = ! empty( $tooth_fairy_template_args['hover'] ) && ! tooth_fairy_is_inherit( $tooth_fairy_template_args['hover'] )
								? $tooth_fairy_template_args['hover']
								: tooth_fairy_get_theme_option( 'image_hover' );

	if ( 'dots' == $tooth_fairy_hover ) {
		$tooth_fairy_post_link = empty( $tooth_fairy_template_args['no_links'] )
								? ( ! empty( $tooth_fairy_template_args['link'] )
									? $tooth_fairy_template_args['link']
									: get_permalink()
									)
								: '';
		$tooth_fairy_target    = ! empty( $tooth_fairy_post_link ) && tooth_fairy_is_external_url( $tooth_fairy_post_link ) && function_exists( 'tooth_fairy_external_links_target' )
								? tooth_fairy_external_links_target()
								: '';
	}
	
	// Meta parts
	$tooth_fairy_components = ! empty( $tooth_fairy_template_args['meta_parts'] )
							? ( is_array( $tooth_fairy_template_args['meta_parts'] )
								? $tooth_fairy_template_args['meta_parts']
								: explode( ',', $tooth_fairy_template_args['meta_parts'] )
								)
							: tooth_fairy_array_get_keys_by_value( tooth_fairy_get_theme_option( 'meta_parts' ) );

	// Featured image
	tooth_fairy_show_post_featured( apply_filters( 'tooth_fairy_filter_args_featured', 
        array(
			'hover'         => $tooth_fairy_hover,
			'no_links'      => ! empty( $tooth_fairy_template_args['no_links'] ),
			'thumb_size'    => ! empty( $tooth_fairy_template_args['thumb_size'] )
								? $tooth_fairy_template_args['thumb_size']
								: tooth_fairy_get_thumb_size(
									tooth_fairy_is_blog_style_use_masonry( $tooth_fairy_blog_style[0] )
										? (	strpos( tooth_fairy_get_theme_option( 'body_style' ), 'full' ) !== false || $tooth_fairy_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( tooth_fairy_get_theme_option( 'body_style' ), 'full' ) !== false || $tooth_fairy_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => tooth_fairy_is_blog_style_use_masonry( $tooth_fairy_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $tooth_fairy_components,
			'class'         => 'dots' == $tooth_fairy_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $tooth_fairy_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $tooth_fairy_post_link )
												? '<a href="' . esc_url( $tooth_fairy_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $tooth_fairy_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $tooth_fairy_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $tooth_fairy_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!