<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0.06
 */

$tooth_fairy_header_css   = '';
$tooth_fairy_header_image = get_header_image();
$tooth_fairy_header_video = tooth_fairy_get_header_video();
if ( ! empty( $tooth_fairy_header_image ) && tooth_fairy_trx_addons_featured_image_override( is_singular() || tooth_fairy_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$tooth_fairy_header_image = tooth_fairy_get_current_mode_image( $tooth_fairy_header_image );
}

$tooth_fairy_header_id = tooth_fairy_get_custom_header_id();
$tooth_fairy_header_meta = get_post_meta( $tooth_fairy_header_id, 'trx_addons_options', true );
if ( ! empty( $tooth_fairy_header_meta['margin'] ) ) {
	tooth_fairy_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( tooth_fairy_prepare_css_value( $tooth_fairy_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $tooth_fairy_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $tooth_fairy_header_id ) ) ); ?>
				<?php
				echo ! empty( $tooth_fairy_header_image ) || ! empty( $tooth_fairy_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $tooth_fairy_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $tooth_fairy_header_image ) {
					echo ' ' . esc_attr( tooth_fairy_add_inline_css_class( 'background-image: url(' . esc_url( $tooth_fairy_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( tooth_fairy_is_on( tooth_fairy_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight tooth-fairy-full-height';
				}
				$tooth_fairy_header_scheme = tooth_fairy_get_theme_option( 'header_scheme' );
				if ( ! empty( $tooth_fairy_header_scheme ) && ! tooth_fairy_is_inherit( $tooth_fairy_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $tooth_fairy_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $tooth_fairy_header_video ) ) {
		get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'tooth_fairy_action_show_layout', $tooth_fairy_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
