<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */

// Page (category, tag, archive, author) title

if ( tooth_fairy_need_page_title() ) {
	tooth_fairy_sc_layouts_showed( 'title', true );
	tooth_fairy_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								tooth_fairy_show_post_meta(
									apply_filters(
										'tooth_fairy_filter_post_meta_args', array(
											'components' => join( ',', tooth_fairy_array_get_keys_by_value( tooth_fairy_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', tooth_fairy_array_get_keys_by_value( tooth_fairy_get_theme_option( 'counters' ) ) ),
											'seo'        => tooth_fairy_is_on( tooth_fairy_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$tooth_fairy_blog_title           = tooth_fairy_get_blog_title();
							$tooth_fairy_blog_title_text      = '';
							$tooth_fairy_blog_title_class     = '';
							$tooth_fairy_blog_title_link      = '';
							$tooth_fairy_blog_title_link_text = '';
							if ( is_array( $tooth_fairy_blog_title ) ) {
								$tooth_fairy_blog_title_text      = $tooth_fairy_blog_title['text'];
								$tooth_fairy_blog_title_class     = ! empty( $tooth_fairy_blog_title['class'] ) ? ' ' . $tooth_fairy_blog_title['class'] : '';
								$tooth_fairy_blog_title_link      = ! empty( $tooth_fairy_blog_title['link'] ) ? $tooth_fairy_blog_title['link'] : '';
								$tooth_fairy_blog_title_link_text = ! empty( $tooth_fairy_blog_title['link_text'] ) ? $tooth_fairy_blog_title['link_text'] : '';
							} else {
								$tooth_fairy_blog_title_text = $tooth_fairy_blog_title;
							}
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr( $tooth_fairy_blog_title_class ); ?>"<?php
								if ( tooth_fairy_is_on( tooth_fairy_get_theme_option( 'seo_snippets' ) ) ) {
									?> itemprop="headline"<?php
								}
							?>>
								<?php
								$tooth_fairy_top_icon = tooth_fairy_get_term_image_small();
								if ( ! empty( $tooth_fairy_top_icon ) ) {
									$tooth_fairy_attr = tooth_fairy_getimagesize( $tooth_fairy_top_icon );
									?>
									<img src="<?php echo esc_url( $tooth_fairy_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'tooth-fairy' ); ?>"
										<?php
										if ( ! empty( $tooth_fairy_attr[3] ) ) {
											tooth_fairy_show_layout( $tooth_fairy_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $tooth_fairy_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $tooth_fairy_blog_title_link ) && ! empty( $tooth_fairy_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $tooth_fairy_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $tooth_fairy_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'tooth_fairy_action_breadcrumbs' );
						$tooth_fairy_breadcrumbs = ob_get_contents();
						ob_end_clean();
						tooth_fairy_show_layout( $tooth_fairy_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
