<?php
/**
 * The template to display the widgets area in the header
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */

// Header sidebar
$tooth_fairy_header_name    = tooth_fairy_get_theme_option( 'header_widgets' );
$tooth_fairy_header_present = ! tooth_fairy_is_off( $tooth_fairy_header_name ) && is_active_sidebar( $tooth_fairy_header_name );
if ( $tooth_fairy_header_present ) {
	tooth_fairy_storage_set( 'current_sidebar', 'header' );
	$tooth_fairy_header_wide = tooth_fairy_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $tooth_fairy_header_name ) ) {
		dynamic_sidebar( $tooth_fairy_header_name );
	}
	$tooth_fairy_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $tooth_fairy_widgets_output ) ) {
		$tooth_fairy_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $tooth_fairy_widgets_output );
		$tooth_fairy_need_columns   = strpos( $tooth_fairy_widgets_output, 'columns_wrap' ) === false;
		if ( $tooth_fairy_need_columns ) {
			$tooth_fairy_columns = max( 0, (int) tooth_fairy_get_theme_option( 'header_columns' ) );
			if ( 0 == $tooth_fairy_columns ) {
				$tooth_fairy_columns = min( 6, max( 1, tooth_fairy_tags_count( $tooth_fairy_widgets_output, 'aside' ) ) );
			}
			if ( $tooth_fairy_columns > 1 ) {
				$tooth_fairy_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $tooth_fairy_columns ) . ' widget', $tooth_fairy_widgets_output );
			} else {
				$tooth_fairy_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $tooth_fairy_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'tooth_fairy_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $tooth_fairy_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $tooth_fairy_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'tooth_fairy_action_before_sidebar', 'header' );
				tooth_fairy_show_layout( $tooth_fairy_widgets_output );
				do_action( 'tooth_fairy_action_after_sidebar', 'header' );
				if ( $tooth_fairy_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $tooth_fairy_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'tooth_fairy_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
