<?php
/**
 * The "Style 7" template to display the post header of the single post or attachment:
 * featured image and title placed in the post header
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.75.0
 */

if ( apply_filters( 'tooth_fairy_filter_single_post_header', is_singular( 'post' ) || is_singular( 'attachment' ) ) ) {
    $tooth_fairy_post_format = str_replace( 'post-format-', '', get_post_format() );
    $post_meta = in_array( $tooth_fairy_post_format, array( 'video' ) ) ? get_post_meta( get_the_ID(), 'trx_addons_options', true ) : false;
    $video_autoplay = ! empty( $post_meta['video_autoplay'] )
        && ! empty( $post_meta['video_list'] )
        && is_array( $post_meta['video_list'] )
        && count( $post_meta['video_list'] ) == 1
        && ( ! empty( $post_meta['video_list'][0]['video_url'] ) || ! empty( $post_meta['video_list'][0]['video_embed'] ) );

    ob_start();
	// Featured image
	tooth_fairy_show_post_featured_image( array(
		'thumb_bg'  => true,
		'popup'     => true,
        'class_avg' => $video_autoplay
            ? 'with_video with_video_autoplay'	// 'with_thumb' is removed
            : '',
        'autoplay'  => $video_autoplay,
        'post_meta' => $post_meta
	) );
	$tooth_fairy_post_header = ob_get_contents();
	ob_end_clean();
	$tooth_fairy_with_featured_image = tooth_fairy_is_with_featured_image( $tooth_fairy_post_header /*, array( 'with_gallery' )*/);
	// Post title and meta
	ob_start();
	tooth_fairy_show_post_title_and_meta( array(
										'content_wrap'  => true,
										'share_type'    => 'list',
										'author_avatar' => true,
										'show_labels'   => true,
										'add_spaces'    => true,
										)
									);
	$tooth_fairy_post_header .= ob_get_contents();
	ob_end_clean();

	if ( strpos( $tooth_fairy_post_header, 'post_featured' ) !== false
		|| strpos( $tooth_fairy_post_header, 'post_title' ) !== false
		|| strpos( $tooth_fairy_post_header, 'post_meta' ) !== false
	) {
		?>
		<div class="post_header_wrap post_header_wrap_in_header post_header_wrap_style_<?php
			echo esc_attr( tooth_fairy_get_theme_option( 'single_style' ) );
            if ( $tooth_fairy_with_featured_image ) {
                echo ' with_featured_image' . ( false && tooth_fairy_get_theme_option( 'single_parallax' ) == 0 ? ' tooth-fairy-full-height' : '' );
            }
		?>">
			<?php
			do_action( 'tooth_fairy_action_before_post_header' );
			tooth_fairy_show_layout( $tooth_fairy_post_header );
			do_action( 'tooth_fairy_action_after_post_header' );
			?>
		</div>
		<?php
	}
}
