<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */

							do_action( 'tooth_fairy_action_page_content_end_text' );
							
							// Widgets area below the content
							tooth_fairy_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'tooth_fairy_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'tooth_fairy_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'tooth_fairy_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'tooth_fairy_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$tooth_fairy_body_style = tooth_fairy_get_theme_option( 'body_style' );
					$tooth_fairy_widgets_name = tooth_fairy_get_theme_option( 'widgets_below_page', 'hide' );
					$tooth_fairy_show_widgets = ! tooth_fairy_is_off( $tooth_fairy_widgets_name ) && is_active_sidebar( $tooth_fairy_widgets_name );
					$tooth_fairy_show_related = tooth_fairy_is_single() && tooth_fairy_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $tooth_fairy_show_widgets || $tooth_fairy_show_related ) {
						if ( 'fullscreen' != $tooth_fairy_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $tooth_fairy_show_related ) {
							do_action( 'tooth_fairy_action_related_posts' );
						}

						// Widgets area below page content
						if ( $tooth_fairy_show_widgets ) {
							tooth_fairy_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $tooth_fairy_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'tooth_fairy_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'tooth_fairy_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! tooth_fairy_is_singular( 'post' ) && ! tooth_fairy_is_singular( 'attachment' ) ) || ! in_array ( tooth_fairy_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<span id="footer_skip_link_anchor" class="tooth_fairy_skip_link_anchor"></span>
				<?php

				do_action( 'tooth_fairy_action_before_footer' );

				// Footer
				$tooth_fairy_footer_type = tooth_fairy_get_theme_option( 'footer_type' );
				if ( 'custom' == $tooth_fairy_footer_type && ! tooth_fairy_is_layouts_available() ) {
					$tooth_fairy_footer_type = 'default';
				}
				get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', "templates/footer-" . sanitize_file_name( $tooth_fairy_footer_type ) ) );

				do_action( 'tooth_fairy_action_after_footer' );

			}
			?>

			<?php do_action( 'tooth_fairy_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'tooth_fairy_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'tooth_fairy_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>