<?php
/**
 * The Header: Logo and main menu
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( tooth_fairy_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'tooth_fairy_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'tooth_fairy_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('tooth_fairy_action_body_wrap_attributes'); ?>>

		<?php do_action( 'tooth_fairy_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'tooth_fairy_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('tooth_fairy_action_page_wrap_attributes'); ?>>

			<?php do_action( 'tooth_fairy_action_page_wrap_start' ); ?>

			<?php
			$tooth_fairy_full_post_loading = ( tooth_fairy_is_singular( 'post' ) || tooth_fairy_is_singular( 'attachment' ) ) && tooth_fairy_get_value_gp( 'action' ) == 'full_post_loading';
			$tooth_fairy_prev_post_loading = ( tooth_fairy_is_singular( 'post' ) || tooth_fairy_is_singular( 'attachment' ) ) && tooth_fairy_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $tooth_fairy_full_post_loading && ! $tooth_fairy_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="tooth_fairy_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'tooth_fairy_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to content", 'tooth-fairy' ); ?></a>
				<?php if ( tooth_fairy_sidebar_present() ) { ?>
				<a class="tooth_fairy_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'tooth_fairy_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'tooth-fairy' ); ?></a>
				<?php } ?>
				<a class="tooth_fairy_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'tooth_fairy_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to footer", 'tooth-fairy' ); ?></a>

				<?php
				do_action( 'tooth_fairy_action_before_header' );

				// Header
				$tooth_fairy_header_type = tooth_fairy_get_theme_option( 'header_type' );
				if ( 'custom' == $tooth_fairy_header_type && ! tooth_fairy_is_layouts_available() ) {
					$tooth_fairy_header_type = 'default';
				}
				get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', "templates/header-" . sanitize_file_name( $tooth_fairy_header_type ) ) );

				// Side menu
				if ( in_array( tooth_fairy_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'tooth_fairy_filter_use_navi_mobile', tooth_fairy_sc_layouts_showed( 'menu_button' ) || $tooth_fairy_header_type == 'default' ) ) {
					get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'tooth_fairy_action_after_header' );

			}
			?>

			<?php do_action( 'tooth_fairy_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( tooth_fairy_is_off( tooth_fairy_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $tooth_fairy_header_type ) ) {
						$tooth_fairy_header_type = tooth_fairy_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $tooth_fairy_header_type && tooth_fairy_is_layouts_available() ) {
						$tooth_fairy_header_id = tooth_fairy_get_custom_header_id();
						if ( $tooth_fairy_header_id > 0 ) {
							$tooth_fairy_header_meta = tooth_fairy_get_custom_layout_meta( $tooth_fairy_header_id );
							if ( ! empty( $tooth_fairy_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$tooth_fairy_footer_type = tooth_fairy_get_theme_option( 'footer_type' );
					if ( 'custom' == $tooth_fairy_footer_type && tooth_fairy_is_layouts_available() ) {
						$tooth_fairy_footer_id = tooth_fairy_get_custom_footer_id();
						if ( $tooth_fairy_footer_id ) {
							$tooth_fairy_footer_meta = tooth_fairy_get_custom_layout_meta( $tooth_fairy_footer_id );
							if ( ! empty( $tooth_fairy_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'tooth_fairy_action_page_content_wrap_class', $tooth_fairy_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'tooth_fairy_filter_is_prev_post_loading', $tooth_fairy_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( tooth_fairy_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'tooth_fairy_action_page_content_wrap_data', $tooth_fairy_prev_post_loading );
			?>>
				<?php
				do_action( 'tooth_fairy_action_page_content_wrap', $tooth_fairy_full_post_loading || $tooth_fairy_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'tooth_fairy_filter_single_post_header', tooth_fairy_is_singular( 'post' ) || tooth_fairy_is_singular( 'attachment' ) ) ) {
					if ( $tooth_fairy_prev_post_loading ) {
						if ( tooth_fairy_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'tooth_fairy_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$tooth_fairy_path = apply_filters( 'tooth_fairy_filter_get_template_part', 'templates/single-styles/' . tooth_fairy_get_theme_option( 'single_style' ) );
					if ( tooth_fairy_get_file_dir( $tooth_fairy_path . '.php' ) != '' ) {
						get_template_part( $tooth_fairy_path );
					}
				}

				// Widgets area above page
				$tooth_fairy_body_style   = tooth_fairy_get_theme_option( 'body_style' );
				$tooth_fairy_widgets_name = tooth_fairy_get_theme_option( 'widgets_above_page', 'hide' );
				$tooth_fairy_show_widgets = ! tooth_fairy_is_off( $tooth_fairy_widgets_name ) && is_active_sidebar( $tooth_fairy_widgets_name );
				if ( $tooth_fairy_show_widgets ) {
					if ( 'fullscreen' != $tooth_fairy_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					tooth_fairy_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $tooth_fairy_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'tooth_fairy_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $tooth_fairy_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'tooth_fairy_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'tooth_fairy_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<span id="content_skip_link_anchor" class="tooth_fairy_skip_link_anchor"></span>
						<?php
						// Single posts banner between prev/next posts
						if ( ( tooth_fairy_is_singular( 'post' ) || tooth_fairy_is_singular( 'attachment' ) )
							&& $tooth_fairy_prev_post_loading 
							&& tooth_fairy_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'tooth_fairy_action_between_posts' );
						}

						// Widgets area above content
						tooth_fairy_create_widgets_area( 'widgets_above_content' );

						do_action( 'tooth_fairy_action_page_content_start_text' );
