<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */

if ( tooth_fairy_sidebar_present() ) {
	
	$tooth_fairy_sidebar_type = tooth_fairy_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $tooth_fairy_sidebar_type && ! tooth_fairy_is_layouts_available() ) {
		$tooth_fairy_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $tooth_fairy_sidebar_type ) {
		// Default sidebar with widgets
		$tooth_fairy_sidebar_name = tooth_fairy_get_theme_option( 'sidebar_widgets' );
		tooth_fairy_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $tooth_fairy_sidebar_name ) ) {
			dynamic_sidebar( $tooth_fairy_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$tooth_fairy_sidebar_id = tooth_fairy_get_custom_sidebar_id();
		do_action( 'tooth_fairy_action_show_layout', $tooth_fairy_sidebar_id );
	}
	$tooth_fairy_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $tooth_fairy_out ) ) {
		$tooth_fairy_sidebar_position    = tooth_fairy_get_theme_option( 'sidebar_position' );
		$tooth_fairy_sidebar_position_ss = tooth_fairy_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $tooth_fairy_sidebar_position );
			echo ' sidebar_' . esc_attr( $tooth_fairy_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $tooth_fairy_sidebar_type );

			$tooth_fairy_sidebar_scheme = apply_filters( 'tooth_fairy_filter_sidebar_scheme', tooth_fairy_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $tooth_fairy_sidebar_scheme ) && ! tooth_fairy_is_inherit( $tooth_fairy_sidebar_scheme ) && 'custom' != $tooth_fairy_sidebar_type ) {
				echo ' scheme_' . esc_attr( $tooth_fairy_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<span id="sidebar_skip_link_anchor" class="tooth_fairy_skip_link_anchor"></span>
			<?php

			do_action( 'tooth_fairy_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $tooth_fairy_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$tooth_fairy_title = apply_filters( 'tooth_fairy_filter_sidebar_control_title', 'float' == $tooth_fairy_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'tooth-fairy' ) : '' );
				$tooth_fairy_text  = apply_filters( 'tooth_fairy_filter_sidebar_control_text', 'above' == $tooth_fairy_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'tooth-fairy' ) : '' );
				?>
				<a href="#" role="button" class="sidebar_control" title="<?php echo esc_attr( $tooth_fairy_title ); ?>"><?php echo esc_html( $tooth_fairy_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'tooth_fairy_action_before_sidebar', 'sidebar' );
				tooth_fairy_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $tooth_fairy_out ) );
				do_action( 'tooth_fairy_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'tooth_fairy_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
