<?php
/**
 * The template to display single post
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */

// Full post loading
$full_post_loading          = tooth_fairy_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = tooth_fairy_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = tooth_fairy_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$tooth_fairy_related_position   = tooth_fairy_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$tooth_fairy_posts_navigation   = tooth_fairy_get_theme_option( 'posts_navigation' );
$tooth_fairy_prev_post          = false;
$tooth_fairy_prev_post_same_cat = (int)tooth_fairy_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( tooth_fairy_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	tooth_fairy_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'tooth_fairy_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $tooth_fairy_posts_navigation ) {
		$tooth_fairy_prev_post = get_previous_post( $tooth_fairy_prev_post_same_cat );  // Get post from same category
		if ( ! $tooth_fairy_prev_post && $tooth_fairy_prev_post_same_cat ) {
			$tooth_fairy_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $tooth_fairy_prev_post ) {
			$tooth_fairy_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $tooth_fairy_prev_post ) ) {
		tooth_fairy_sc_layouts_showed( 'featured', false );
		tooth_fairy_sc_layouts_showed( 'title', false );
		tooth_fairy_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $tooth_fairy_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'tooth_fairy_filter_get_template_part', 'templates/content', 'single-' . tooth_fairy_get_theme_option( 'single_style' ) ), 'single-' . tooth_fairy_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $tooth_fairy_related_position, 'inside' ) === 0 ) {
		$tooth_fairy_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'tooth_fairy_action_related_posts' );
		$tooth_fairy_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $tooth_fairy_related_content ) ) {
			$tooth_fairy_related_position_inside = max( 0, min( 9, tooth_fairy_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $tooth_fairy_related_position_inside ) {
				$tooth_fairy_related_position_inside = mt_rand( 1, 9 );
			}

			$tooth_fairy_p_number         = 0;
			$tooth_fairy_related_inserted = false;
			$tooth_fairy_in_block         = false;
			$tooth_fairy_content_start    = strpos( $tooth_fairy_content, '<div class="post_content' );
			$tooth_fairy_content_end      = strrpos( $tooth_fairy_content, '</div>' );

			for ( $i = max( 0, $tooth_fairy_content_start ); $i < min( strlen( $tooth_fairy_content ) - 3, $tooth_fairy_content_end ); $i++ ) {
				if ( $tooth_fairy_content[ $i ] != '<' ) {
					continue;
				}
				if ( $tooth_fairy_in_block ) {
					if ( strtolower( substr( $tooth_fairy_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$tooth_fairy_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $tooth_fairy_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $tooth_fairy_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$tooth_fairy_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $tooth_fairy_content[ $i + 1 ] && in_array( $tooth_fairy_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$tooth_fairy_p_number++;
					if ( $tooth_fairy_related_position_inside == $tooth_fairy_p_number ) {
						$tooth_fairy_related_inserted = true;
						$tooth_fairy_content = ( $i > 0 ? substr( $tooth_fairy_content, 0, $i ) : '' )
											. $tooth_fairy_related_content
											. substr( $tooth_fairy_content, $i );
					}
				}
			}
			if ( ! $tooth_fairy_related_inserted ) {
				if ( $tooth_fairy_content_end > 0 ) {
					$tooth_fairy_content = substr( $tooth_fairy_content, 0, $tooth_fairy_content_end ) . $tooth_fairy_related_content . substr( $tooth_fairy_content, $tooth_fairy_content_end );
				} else {
					$tooth_fairy_content .= $tooth_fairy_related_content;
				}
			}
		}

		tooth_fairy_show_layout( $tooth_fairy_content );
	}

	// Comments
	do_action( 'tooth_fairy_action_before_comments' );
	comments_template();
	do_action( 'tooth_fairy_action_after_comments' );

	// Related posts
	if ( 'below_content' == $tooth_fairy_related_position
		&& ( 'scroll' != $tooth_fairy_posts_navigation || (int)tooth_fairy_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)tooth_fairy_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'tooth_fairy_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $tooth_fairy_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $tooth_fairy_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $tooth_fairy_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $tooth_fairy_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'tooth_fairy_action_nav_links_single_scroll_data', $tooth_fairy_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
