<?php
/**
 * The template to display the user's avatar, bio and socials on the Author page
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.71.0
 */
?>

<div class="author_page author vcard"<?php
	if ( tooth_fairy_is_on( tooth_fairy_get_theme_option( 'seo_snippets' ) ) ) {
		?> itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( tooth_fairy_get_protocol( true ) ); ?>//schema.org/Person"<?php
	}
?>>

	<div class="author_avatar"<?php
		if ( tooth_fairy_is_on( tooth_fairy_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="image"<?php
		}
	?>>
		<?php
		$tooth_fairy_mult = tooth_fairy_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $tooth_fairy_mult );
		?>
	</div>

	<h4 class="author_title"<?php
		if ( tooth_fairy_is_on( tooth_fairy_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="name"<?php
		}
	?>><span class="fn"><?php the_author(); ?></span></h4>

	<?php
	$tooth_fairy_author_description = get_the_author_meta( 'description' );
	if ( ! empty( $tooth_fairy_author_description ) ) {
		?>
		<div class="author_bio"<?php
			if ( tooth_fairy_is_on( tooth_fairy_get_theme_option( 'seo_snippets' ) ) ) {
				?> itemprop="description"<?php
			}
		?>><?php echo wp_kses( wpautop( $tooth_fairy_author_description ), 'tooth_fairy_kses_content' ); ?></div>
		<?php
	}
	?>

	<div class="author_details">
		<span class="author_posts_total">
			<?php
			$tooth_fairy_posts_total = count_user_posts( get_the_author_meta('ID'), 'post' );
			if ( $tooth_fairy_posts_total > 0 ) {
				// Translators: Add the author's posts number to the message
				echo wp_kses( sprintf( _n( '%s article published', '%s articles published', $tooth_fairy_posts_total, 'tooth-fairy' ),
										'<span class="author_posts_total_value">' . number_format_i18n( $tooth_fairy_posts_total ) . '</span>'
								 		),
							'tooth_fairy_kses_content'
							);
			} else {
				esc_html_e( 'No posts published.', 'tooth-fairy' );
			}
			?>
		</span><?php
			ob_start();
			do_action( 'tooth_fairy_action_user_meta', 'author-page' );
			$tooth_fairy_socials = ob_get_contents();
			ob_end_clean();
			tooth_fairy_show_layout( $tooth_fairy_socials,
				'<span class="author_socials"><span class="author_socials_caption">' . esc_html__( 'Follow:', 'tooth-fairy' ) . '</span>',
				'</span>'
			);
		?>
	</div>

</div>
