<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */

$tooth_fairy_template_args = get_query_var( 'tooth_fairy_template_args' );

if ( is_array( $tooth_fairy_template_args ) ) {
	$tooth_fairy_columns    = empty( $tooth_fairy_template_args['columns'] ) ? 2 : max( 1, $tooth_fairy_template_args['columns'] );
	$tooth_fairy_blog_style = array( $tooth_fairy_template_args['type'], $tooth_fairy_columns );
    $tooth_fairy_columns_class = tooth_fairy_get_column_class( 1, $tooth_fairy_columns, ! empty( $tooth_fairy_template_args['columns_tablet']) ? $tooth_fairy_template_args['columns_tablet'] : '', ! empty($tooth_fairy_template_args['columns_mobile']) ? $tooth_fairy_template_args['columns_mobile'] : '' );
} else {
	$tooth_fairy_template_args = array();
	$tooth_fairy_blog_style = explode( '_', tooth_fairy_get_theme_option( 'blog_style' ) );
	$tooth_fairy_columns    = empty( $tooth_fairy_blog_style[1] ) ? 2 : max( 1, $tooth_fairy_blog_style[1] );
    $tooth_fairy_columns_class = tooth_fairy_get_column_class( 1, $tooth_fairy_columns );
}
$tooth_fairy_expanded   = ! tooth_fairy_sidebar_present() && tooth_fairy_get_theme_option( 'expand_content' ) == 'expand';

$tooth_fairy_post_format = get_post_format();
$tooth_fairy_post_format = empty( $tooth_fairy_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tooth_fairy_post_format );

?><div class="<?php
	if ( ! empty( $tooth_fairy_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( tooth_fairy_is_blog_style_use_masonry( $tooth_fairy_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $tooth_fairy_columns ) : esc_attr( $tooth_fairy_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $tooth_fairy_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $tooth_fairy_columns )
				. ' post_layout_' . esc_attr( $tooth_fairy_blog_style[0] )
				. ' post_layout_' . esc_attr( $tooth_fairy_blog_style[0] ) . '_' . esc_attr( $tooth_fairy_columns )
	);
	tooth_fairy_add_blog_animation( $tooth_fairy_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$tooth_fairy_hover      = ! empty( $tooth_fairy_template_args['hover'] ) && ! tooth_fairy_is_inherit( $tooth_fairy_template_args['hover'] )
							? $tooth_fairy_template_args['hover']
							: tooth_fairy_get_theme_option( 'image_hover' );

	$tooth_fairy_components = ! empty( $tooth_fairy_template_args['meta_parts'] )
							? ( is_array( $tooth_fairy_template_args['meta_parts'] )
								? $tooth_fairy_template_args['meta_parts']
								: explode( ',', $tooth_fairy_template_args['meta_parts'] )
								)
							: tooth_fairy_array_get_keys_by_value( tooth_fairy_get_theme_option( 'meta_parts' ) );

	tooth_fairy_show_post_featured( apply_filters( 'tooth_fairy_filter_args_featured',
		array(
			'thumb_size' => ! empty( $tooth_fairy_template_args['thumb_size'] )
				? $tooth_fairy_template_args['thumb_size']
				: tooth_fairy_get_thumb_size(
					'classic' == $tooth_fairy_blog_style[0]
						? ( strpos( tooth_fairy_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $tooth_fairy_columns > 2 ? 'big' : 'huge' )
								: ( $tooth_fairy_columns > 2
									? ( $tooth_fairy_expanded ? 'square' : 'square' )
									: ($tooth_fairy_columns > 1 ? 'square' : ( $tooth_fairy_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( tooth_fairy_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $tooth_fairy_columns > 2 ? 'masonry-big' : 'full' )
								: ($tooth_fairy_columns === 1 ? ( $tooth_fairy_expanded ? 'huge' : 'big' ) : ( $tooth_fairy_columns <= 2 && $tooth_fairy_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $tooth_fairy_hover,
			'meta_parts' => $tooth_fairy_components,
			'no_links'   => ! empty( $tooth_fairy_template_args['no_links'] ),
        ),
        'content-classic',
        $tooth_fairy_template_args
    ) );

	// Title and post meta
	$tooth_fairy_show_title = get_the_title() != '';
	$tooth_fairy_show_meta  = count( $tooth_fairy_components ) > 0 && ! in_array( $tooth_fairy_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $tooth_fairy_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'tooth_fairy_filter_show_blog_meta', $tooth_fairy_show_meta, $tooth_fairy_components, 'classic' ) ) {
				if ( count( $tooth_fairy_components ) > 0 ) {
					do_action( 'tooth_fairy_action_before_post_meta' );
					tooth_fairy_show_post_meta(
						apply_filters(
							'tooth_fairy_filter_post_meta_args', array(
							'components' => join( ',', $tooth_fairy_components ),
							'seo'        => false,
							'echo'       => true,
						), $tooth_fairy_blog_style[0], $tooth_fairy_columns
						)
					);
					do_action( 'tooth_fairy_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'tooth_fairy_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'tooth_fairy_action_before_post_title' );
				if ( empty( $tooth_fairy_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'tooth_fairy_action_after_post_title' );
			}

			if( !in_array( $tooth_fairy_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'tooth_fairy_filter_show_blog_readmore', ! $tooth_fairy_show_title || ! empty( $tooth_fairy_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $tooth_fairy_template_args['no_links'] ) ) {
						do_action( 'tooth_fairy_action_before_post_readmore' );
						tooth_fairy_show_post_more_link( $tooth_fairy_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'tooth_fairy_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $tooth_fairy_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('tooth_fairy_filter_show_blog_excerpt', empty($tooth_fairy_template_args['hide_excerpt']) && tooth_fairy_get_theme_option('excerpt_length') > 0, 'classic')) {
			tooth_fairy_show_post_content($tooth_fairy_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $tooth_fairy_template_args['more_button'] )) {
			if ( empty( $tooth_fairy_template_args['no_links'] ) ) {
				do_action( 'tooth_fairy_action_before_post_readmore' );
				tooth_fairy_show_post_more_link( $tooth_fairy_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'tooth_fairy_action_after_post_readmore' );
			}
		}
		$tooth_fairy_content = ob_get_contents();
		ob_end_clean();
		tooth_fairy_show_layout($tooth_fairy_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
