<?php
/**
 * The default template to display the content of the single post or attachment
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */
?>
<article id="post-<?php the_ID(); ?>"
	<?php
	post_class( 'post_item_single'
		. ' post_type_' . esc_attr( get_post_type() ) 
		. ' post_format_' . esc_attr( str_replace( 'post-format-', '', get_post_format() ) )
	);
	tooth_fairy_add_seo_itemprops();
	?>
>
<?php

	do_action( 'tooth_fairy_action_before_post_data' );
	tooth_fairy_add_seo_snippets();
	do_action( 'tooth_fairy_action_after_post_data' );

	do_action( 'tooth_fairy_action_before_post_content' );

	// Post content
	$tooth_fairy_meta_components = tooth_fairy_array_get_keys_by_value( tooth_fairy_get_theme_option( 'meta_parts' ) );
	$tooth_fairy_share_position  = tooth_fairy_array_get_keys_by_value( tooth_fairy_get_theme_option( 'share_position' ) );
	?>
	<div class="post_content post_content_single entry-content<?php
		if ( in_array( 'left', $tooth_fairy_share_position ) && in_array( 'share', $tooth_fairy_meta_components ) ) {
			echo ' post_info_vertical_present' . ( in_array( 'top', $tooth_fairy_share_position ) ? ' post_info_vertical_hide_on_mobile' : '' );
		}
	?>"<?php
		if ( tooth_fairy_is_on( tooth_fairy_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="mainEntityOfPage"<?php
		}
	?>>
		<?php
		if ( in_array( 'left', $tooth_fairy_share_position ) && in_array( 'share', $tooth_fairy_meta_components ) ) {
			?><div class="post_info_vertical<?php
				if ( tooth_fairy_get_theme_option( 'share_fixed' ) > 0 ) {
					echo ' post_info_vertical_fixed';
				}
			?>"><?php
				tooth_fairy_show_post_meta(
					apply_filters(
						'tooth_fairy_filter_post_meta_args',
						array(
							'components'      => 'share',
							'class'           => 'post_share_vertical',
							'share_type'      => 'block',
							'share_direction' => 'vertical',
						),
						'single',
						1
					)
				);
			?></div><?php
		}
		the_content();
		?>
	</div>
	<?php

	do_action( 'tooth_fairy_action_after_post_content' );
	
	// Post footer: Tags, likes, share, author, prev/next links and comments
	do_action( 'tooth_fairy_action_before_post_footer' );
	?>
	<div class="post_footer post_footer_single entry-footer">
		<?php
		tooth_fairy_show_post_pagination();
		if ( is_single() && ! is_attachment() ) {
			tooth_fairy_show_post_footer();
		}
		?>
	</div>
	<?php
	do_action( 'tooth_fairy_action_after_post_footer' );
	?>
</article>
