<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$tooth_fairy_copyright_scheme = tooth_fairy_get_theme_option( 'copyright_scheme' );
if ( ! empty( $tooth_fairy_copyright_scheme ) && ! tooth_fairy_is_inherit( $tooth_fairy_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $tooth_fairy_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$tooth_fairy_copyright = tooth_fairy_get_theme_option( 'copyright' );
			if ( ! empty( $tooth_fairy_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$tooth_fairy_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $tooth_fairy_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$tooth_fairy_copyright = tooth_fairy_prepare_macros( $tooth_fairy_copyright );
				// Display copyright
				echo wp_kses( nl2br( $tooth_fairy_copyright ), 'tooth_fairy_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
