<?php
/**
 * The template to display default site footer
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0.10
 */

$tooth_fairy_footer_id = tooth_fairy_get_custom_footer_id();
$tooth_fairy_footer_meta = get_post_meta( $tooth_fairy_footer_id, 'trx_addons_options', true );
if ( ! empty( $tooth_fairy_footer_meta['margin'] ) ) {
	tooth_fairy_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( tooth_fairy_prepare_css_value( $tooth_fairy_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $tooth_fairy_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $tooth_fairy_footer_id ) ) ); ?>
						<?php
						$tooth_fairy_footer_scheme = tooth_fairy_get_theme_option( 'footer_scheme' );
						if ( ! empty( $tooth_fairy_footer_scheme ) && ! tooth_fairy_is_inherit( $tooth_fairy_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $tooth_fairy_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'tooth_fairy_action_show_layout', $tooth_fairy_footer_id );
	?>
</footer><!-- /.footer_wrap -->
