<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0.10
 */

// Footer sidebar
$tooth_fairy_footer_name    = tooth_fairy_get_theme_option( 'footer_widgets' );
$tooth_fairy_footer_present = ! tooth_fairy_is_off( $tooth_fairy_footer_name ) && is_active_sidebar( $tooth_fairy_footer_name );
if ( $tooth_fairy_footer_present ) {
	tooth_fairy_storage_set( 'current_sidebar', 'footer' );
	$tooth_fairy_footer_wide = tooth_fairy_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $tooth_fairy_footer_name ) ) {
		dynamic_sidebar( $tooth_fairy_footer_name );
	}
	$tooth_fairy_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $tooth_fairy_out ) ) {
		$tooth_fairy_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $tooth_fairy_out );
		$tooth_fairy_need_columns = true;   //or check: strpos($tooth_fairy_out, 'columns_wrap')===false;
		if ( $tooth_fairy_need_columns ) {
			$tooth_fairy_columns = max( 0, (int) tooth_fairy_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $tooth_fairy_columns ) {
				$tooth_fairy_columns = min( 4, max( 1, tooth_fairy_tags_count( $tooth_fairy_out, 'aside' ) ) );
			}
			if ( $tooth_fairy_columns > 1 ) {
				$tooth_fairy_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $tooth_fairy_columns ) . ' widget', $tooth_fairy_out );
			} else {
				$tooth_fairy_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $tooth_fairy_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'tooth_fairy_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $tooth_fairy_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $tooth_fairy_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'tooth_fairy_action_before_sidebar', 'footer' );
				tooth_fairy_show_layout( $tooth_fairy_out );
				do_action( 'tooth_fairy_action_after_sidebar', 'footer' );
				if ( $tooth_fairy_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $tooth_fairy_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'tooth_fairy_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
