<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0
 */

$tooth_fairy_args = get_query_var( 'tooth_fairy_logo_args' );

// Site logo
$tooth_fairy_logo_type   = isset( $tooth_fairy_args['type'] ) ? $tooth_fairy_args['type'] : '';
$tooth_fairy_logo_image  = tooth_fairy_get_logo_image( $tooth_fairy_logo_type );
$tooth_fairy_logo_text   = tooth_fairy_is_on( tooth_fairy_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$tooth_fairy_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $tooth_fairy_logo_image['logo'] ) || ! empty( $tooth_fairy_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $tooth_fairy_logo_image['logo'] ) ) {
			if ( empty( $tooth_fairy_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($tooth_fairy_logo_image['logo']) && (int) $tooth_fairy_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$tooth_fairy_attr = tooth_fairy_getimagesize( $tooth_fairy_logo_image['logo'] );
				echo '<img src="' . esc_url( $tooth_fairy_logo_image['logo'] ) . '"'
						. ( ! empty( $tooth_fairy_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $tooth_fairy_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $tooth_fairy_logo_text ) . '"'
						. ( ! empty( $tooth_fairy_attr[3] ) ? ' ' . wp_kses_data( $tooth_fairy_attr[3] ) : '' )
						. '>';
			}
		} else {
			tooth_fairy_show_layout( tooth_fairy_prepare_macros( $tooth_fairy_logo_text ), '<span class="logo_text">', '</span>' );
			tooth_fairy_show_layout( tooth_fairy_prepare_macros( $tooth_fairy_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
