<?php
/**
 * The template 'Style 5' to displaying related posts
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0.54
 */

$tooth_fairy_link        = get_permalink();
$tooth_fairy_post_format = get_post_format();
$tooth_fairy_post_format = empty( $tooth_fairy_post_format ) ? 'standard' : str_replace( 'post-format-', '', $tooth_fairy_post_format );
?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item post_format_' . esc_attr( $tooth_fairy_post_format ) ); ?> data-post-id="<?php the_ID(); ?>">
	<?php
	tooth_fairy_show_post_featured(
		array(
			'thumb_size'    => apply_filters( 'tooth_fairy_filter_related_thumb_size', tooth_fairy_get_thumb_size( (int) tooth_fairy_get_theme_option( 'related_posts' ) == 1 ? 'big' : 'med' ) ),
		)
	);
	?>
	<div class="post_header entry-header">
		<h6 class="post_title entry-title"><a href="<?php echo esc_url( $tooth_fairy_link ); ?>"><?php
			if ( '' == get_the_title() ) {
				esc_html_e( '- No title -', 'tooth-fairy' );
			} else {
				the_title();
			}
		?></a></h6>
		<?php
		if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
			?>
			<div class="post_meta">
				<a href="<?php echo esc_url( $tooth_fairy_link ); ?>" class="post_meta_item post_date"><?php echo wp_kses_data( tooth_fairy_get_date() ); ?></a>
			</div>
			<?php
		}
		?>
	</div>
</div>
