<?php
/**
 * The template to display Admin notices
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.98.0
 */

$tooth_fairy_skins_url   = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$tooth_fairy_active_skin = tooth_fairy_skins_get_active_skin_name();
?>
<div class="tooth_fairy_admin_notice tooth_fairy_skins_notice notice notice-error">
	<?php
	// Theme image
	$tooth_fairy_theme_img = tooth_fairy_get_file_url( 'screenshot.jpg' );
	if ( '' != $tooth_fairy_theme_img ) {
		?>
		<div class="tooth_fairy_notice_image"><img src="<?php echo esc_url( $tooth_fairy_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'tooth-fairy' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="tooth_fairy_notice_title">
		<?php esc_html_e( 'Active skin is missing!', 'tooth-fairy' ); ?>
	</h3>
	<div class="tooth_fairy_notice_text">
		<p>
			<?php
			// Translators: Add a current skin name to the message
			echo wp_kses_data( sprintf( __( "Your active skin <b>'%s'</b> is missing. Usually this happens when the theme is updated directly through the server or FTP.", 'tooth-fairy' ), ucfirst( $tooth_fairy_active_skin ) ) );
			?>
		</p>
		<p>
			<?php
			echo wp_kses_data( __( "Please use only <b>'ThemeREX Updater v.1.6.0+'</b> plugin for your future updates.", 'tooth-fairy' ) );
			?>
		</p>
		<p>
			<?php
			echo wp_kses_data( __( "But no worries! You can re-download the skin via 'Skins Manager' ( Theme Panel - Theme Dashboard - Skins ).", 'tooth-fairy' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="tooth_fairy_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $tooth_fairy_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'tooth-fairy' );
			?>
		</a>
	</div>
</div>
