<?php
/**
 * The template to display Admin notices
 *
 * @package TOOTH FAIRY
 * @since TOOTH FAIRY 1.0.64
 */

$tooth_fairy_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$tooth_fairy_skins_args = get_query_var( 'tooth_fairy_skins_notice_args' );
?>
<div class="tooth_fairy_admin_notice tooth_fairy_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$tooth_fairy_theme_img = tooth_fairy_get_file_url( 'screenshot.jpg' );
	if ( '' != $tooth_fairy_theme_img ) {
		?>
		<div class="tooth_fairy_notice_image"><img src="<?php echo esc_url( $tooth_fairy_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'tooth-fairy' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="tooth_fairy_notice_title">
		<?php esc_html_e( 'New skins are available', 'tooth-fairy' ); ?>
	</h3>
	<?php

	// Description
	$tooth_fairy_total      = $tooth_fairy_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$tooth_fairy_skins_msg  = $tooth_fairy_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $tooth_fairy_total, 'tooth-fairy' ), $tooth_fairy_total ) . '</strong>'
							: '';
	$tooth_fairy_total      = $tooth_fairy_skins_args['free'];
	$tooth_fairy_skins_msg .= $tooth_fairy_total > 0
							? ( ! empty( $tooth_fairy_skins_msg ) ? ' ' . esc_html__( 'and', 'tooth-fairy' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $tooth_fairy_total, 'tooth-fairy' ), $tooth_fairy_total ) . '</strong>'
							: '';
	$tooth_fairy_total      = $tooth_fairy_skins_args['pay'];
	$tooth_fairy_skins_msg .= $tooth_fairy_skins_args['pay'] > 0
							? ( ! empty( $tooth_fairy_skins_msg ) ? ' ' . esc_html__( 'and', 'tooth-fairy' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $tooth_fairy_total, 'tooth-fairy' ), $tooth_fairy_total ) . '</strong>'
							: '';
	?>
	<div class="tooth_fairy_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'tooth-fairy' ), $tooth_fairy_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="tooth_fairy_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $tooth_fairy_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			esc_html_e( 'Go to Skins manager', 'tooth-fairy' );
			?>
		</a>
		<?php
		// Dismiss notice for 7 days
		?>
		<a href="#" role="button" class="button button-secondary tooth_fairy_notice_button_dismiss" data-notice="skins"><i class="dashicons dashicons-no-alt"></i> 
			<?php
			esc_html_e( 'Dismiss', 'tooth-fairy' );
			?>
		</a>
		<?php
		// Hide notice forever
		?>
		<a href="#" role="button" class="button button-secondary tooth_fairy_notice_button_hide" data-notice="skins"><i class="dashicons dashicons-no-alt"></i> 
			<?php
			esc_html_e( 'Never show again', 'tooth-fairy' );
			?>
		</a>
	</div>
</div>
