<?php 
/**
 * Search Page
 */

get_header();

/**
 * Arguments
 * 
 * Modify the query with
 * different arguments properties.
 */
$args = array_merge(
    $wp_query->query_vars, 
    array('post_type' => 
        get_theme_mod('search_post_types', ['post', 'page', 'portfolio', 'product'])
    )
);

$query = new WP_Query($args);

/**
 * Columns
 */
$torfa_search_item_class = 'selector';

switch (get_theme_mod('search_columns', '3')) {
    case '1':
        $torfa_search_item_class .= ' col-12';
        break;
    case '2':
        $torfa_search_item_class .= ' col-sm-6';
        break;
    default:
        $torfa_search_item_class .= ' col-md-4 col-sm-6';
        break;
    case '4':
        $torfa_search_item_class .= ' col-md-3 col-sm-6';
        break;
}

/**
 * Sidebar
 * 
 * Three different options for sidebar
 * two are for placements on the left
 * and the right and the other one to
 * hide the sidebar.
 */
$torfa_search_row_class = 'row';
$torfa_search_posts_class = 'col-lg-8';
$torfa_search_sidebar_class = 'col-lg-4';

if (get_theme_mod('search_sidebar', '3') == '1') {
    $torfa_search_row_class .= ' flex-row-reverse';
} elseif (get_theme_mod('search_sidebar', '3') == '3') {
    $torfa_search_posts_class = 'col-12';
    $torfa_search_sidebar_class = 'h-display-none';
}

/**
 * Hero 
 */
$torfa_search_hero_style = $torfa_search_overlay_style = [];

/**
 * Image
 */
if (get_theme_mod('search_hero_image')) {
    $torfa_search_hero_style[] = 'background-image: url('. esc_url(wp_get_attachment_url(get_theme_mod('search_hero_image'))) .')';
}

/**
 * Overlay
 */
if (get_theme_mod('search_hero_overlay', '2') == '1') {
    if (get_theme_mod('search_hero_overlay_opacity')) {
        $torfa_search_overlay_style[] = 'opacity: '. get_theme_mod('search_hero_overlay_opacity') .'';
    }

    if (get_theme_mod('search_hero_overlay_color')) {
        $torfa_search_overlay_style[] = 'background-color: '. get_theme_mod('search_hero_overlay_color') .'';
    }
}

torfa_breadcrumbs(1, get_theme_mod('breadcrumbs_separator'));
?>
<?php if (!$query->have_posts()) : ?>
    <div class="t-search h-large-top-padding h-large-bottom-padding">
        <div class="container">
            <h1><?php echo wp_kses_post(__('Nothing Found', 'torfa')) ?></h1>
            <p><?php echo wp_kses_post(__('The post you were looking for couldn\'t be found. The post could be removed or you misspelled the word while searching for it.', 'torfa')) ?></p>
            <?php get_search_form() ?>
        </div>
    </div>
<?php endif; ?>
<?php if ($query->have_posts()) : ?>
    <div class="l-blog-wrapper h-large-top-padding h-large-bottom-padding">
        <div class="container">
            <div class="<?php echo esc_attr($torfa_search_row_class) ?>">
                <div class="l-blog-wrapper__posts-holder l-blog-wrapper__posts-holder--meta-outside <?php echo esc_attr($torfa_search_posts_class) ?>">
                    <div class="row masonry">
                        <?php while ($query->have_posts()) : $query->the_post() ?>
                            <div <?php post_class($torfa_search_item_class) ?> id="id-<?php the_ID() ?>" data-id="<?php the_ID() ?>"> 
                                <div class="o-blog-post h-fadeInNeuron wow">
                                    <div class="o-blog-post__content">
                                        <div class="o-blog-post__meta">
                                            <span class="o-blog-post__type a-separator">
                                                <span><?php echo esc_attr(get_post_type()) ?></span>
                                            </span>
                                        </div>
                                        <h3 class="o-blog-post__title">
                                            <a href="<?php the_permalink() ?>"><?php the_title() ?></a>
                                        </h3>
                                        <?php the_excerpt() ?>
                                        <a class="d-flex align-items-center a-read-more" href="<?php the_permalink() ?>"><?php echo esc_html__('Read More', 'torfa') ?><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-right"><polyline points="9 18 15 12 9 6"></polyline></svg></a>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
                <?php if (get_theme_mod('search_sidebar', '3') !== '3') : ?>
                    <div class="<?php echo esc_attr($torfa_search_sidebar_class) ?>">
                        <div class="o-main-sidebar l-blog-wrapper__sidebar">
                            <?php get_sidebar() ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php 
endif; wp_reset_postdata();

neuron_pagination();

get_footer();