<?php
/**
 * Blog Single
 */
get_header();

get_template_part('templates/hero/standard');

/**
 * Sidebar
 */
$torfa_row_class = 'row';
$torfa_posts_class = 'col-lg-8';
$torfa_sidebar_class = 'col-lg-4';

if (torfa_inherit_option('blog_post_sidebar', 'blog_post_sidebar', '2') == '1') {
    $torfa_row_class .= ' flex-row-reverse';
} elseif (torfa_inherit_option('blog_post_sidebar', 'blog_post_sidebar', '2') == '3') {
    $torfa_posts_class = 'col-12';
    $torfa_sidebar_class = 'h-display-none';
}

/**
 * Prevent Empty Sidebar
 */
if (!is_active_sidebar('main-sidebar')) {
    $torfa_posts_class = 'col-12';
    $torfa_sidebar_class = 'h-display-none';
}


if (have_posts()) : while (have_posts()) : the_post();

/**
 * Breadcrumb
 */
$torfa_page_breadcrumb = torfa_inherit_option('general_breadcrumb', 'breadcrumbs_post_visibility', '2');
torfa_breadcrumbs($torfa_page_breadcrumb, get_theme_mod('breadcrumbs_separator'));

if (torfa_inherit_option('blog_post_sidebar', 'blog_post_sidebar', '2') != '3' && is_active_sidebar('main-sidebar')) {
    do_action('torfa_open_container'); // Add container when sidebar is displayed
}
?>
<div class="p-blog-single h-large-top-padding h-large-bottom-padding">
    <div class="<?php echo esc_attr($torfa_row_class) ?>">
        <div class="<?php echo esc_attr($torfa_posts_class) ?>">
            <div class="p-blog-single__wrapper o-blog-post">
                <div class="p-blog-single__wrapper__header">
                    <?php if (torfa_inherit_option('blog_post_sidebar', 'blog_post_sidebar', '2') == '3') { ?>
                    <div class="container"> 
                    <?php } // Remove divs when sidebar is not displayed ?>
                        <?php if (get_field('blog_post_thumbnail') == '4' && get_field('blog_post_custom_thumbnail')) : ?>
                            <div class="o-blog-post__thumbnail">
                                <img src="<?php echo esc_url(get_field('blog_post_custom_thumbnail')) ?>">
                            </div>
                        <?php elseif (has_post_thumbnail() && torfa_inherit_option('blog_post_thumbnail', 'blog_post_thumbnail', '1') == '1') : ?> 
                            <div class="o-blog-post__thumbnail">
                                <?php the_post_thumbnail() ?>
                            </div>
                        <?php endif; ?>
                        <?php if (torfa_inherit_option('blog_post_sidebar', 'blog_post_sidebar', '2') == '3') { ?>
                        <div class="row">
                            <div class="col-md-10 offset-md-1">
                                <?php } // Remove divs when sidebar is not displayed ?>
                                <div class="o-blog-post__content">
                                    <div class="o-blog-post__meta">
                                        <span class="o-blog-post__time a-separator">
                                            <span><?php the_time(get_option('date_format')) ?></span>
                                        </span>
                                        <?php get_template_part('templates/taxonomy/categories') ?>
                                    </div>
                                    <?php 
                                    /**
                                     * Post Title
                                     */
                                    if (torfa_inherit_option('general_title', 'general_title_post', '1') == '1') {
                                        the_title('<h1 class="o-blog-post__title">', '</h1>');
                                    }
                                    ?>
                                    <div class="p-blog-single__content h-clearfix">
                                        <?php the_content() ?>
                                    </div>
                                    <?php wp_link_pages(array('before' => '<div class="o-pagination o-pagination--pages"><span class="o-pagination__title">' . esc_attr__( 'Pages:', 'torfa' ) . '</span><div class="o-pagination--pages__numbers">', 'after' => '</div></div>', 'link_before' => '<span>', 'link_after' => '</span>', 'next_or_number' => 'next_and_number', 'separator' => '', 'nextpagelink' => esc_attr__('&raquo;', 'torfa'), 'previouspagelink' => esc_attr__('&laquo;', 'torfa'), 'pagelink' => '%')); ?>
                                    <?php paginate_links() ?> 
                                </div>
                                <?php get_template_part('templates/taxonomy/tags-cloud') ?>
                                <?php get_template_part('templates/extra/author-box') ?>
                                <?php if (torfa_inherit_option('blog_post_sidebar', 'blog_post_sidebar', '2') == '3') { ?>
                            </div>
                        </div>                    
                    </div>
                    <?php } // Remove divs when sidebar is not displayed ?>
                </div>
                <?php 
                /**
                 * Related
                 */
                $torfa_related_template = get_field('related_posts') == '2' ? get_field('related_posts_template') : get_theme_mod('blog_post_related_template');

                if (torfa_inherit_option('related_posts', 'blog_post_related', '2') == '1' && $torfa_related_template) {
                    echo torfa_get_custom_template($torfa_related_template);
                }

                if (torfa_inherit_option('blog_post_share', 'blog_post_share', '2') == '1' || have_comments() || comments_open()) {
                ?>
                <div class="p-blog-single__wrapper__footer">
                    <?php if (torfa_inherit_option('blog_post_sidebar', 'blog_post_sidebar', '2') == '3') { ?>
                    <div class="container">
                        <div class="row">
                            <div class="col-md-10 offset-md-1">
                            <?php } // Remove divs when sidebar is not displayed ?>
                                <?php if (torfa_inherit_option('blog_post_share', 'blog_post_share', '2') == '1') : ?>
                                    <div class="p-blog-single__social-media">
                                        <?php get_template_part('templates/extra/share') ?>
                                    </div>
                                <?php endif; ?>
                                <?php comments_template(); ?>
                            <?php if (torfa_inherit_option('blog_post_sidebar', 'blog_post_sidebar', '2') == '3') { ?>
                            </div>
                        </div>
                    </div>
                    <?php } // Remove divs when sidebar is not displayed ?>
                </div>
                <?php } ?>
            </div>
        </div>
        <?php if (torfa_inherit_option('blog_post_sidebar', 'blog_post_sidebar', '2') != '3' && is_active_sidebar('main-sidebar')) : ?>
            <div class="<?php echo esc_attr($torfa_sidebar_class) ?>">
                <div class="o-main-sidebar">
                    <?php get_sidebar() ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php 
if (torfa_inherit_option('blog_post_sidebar', 'blog_post_sidebar', '2') != '3' && is_active_sidebar('main-sidebar')) {
    do_action('torfa_close_container'); // Close container when sidebar is displayed
}

get_template_part('templates/single/navigation');

endwhile; endif;

get_footer();