<?php
/**
 * Footer Copyright
 */
if (torfa_inherit_option('footer_copyright_visibility', 'footer_copyright_visibility', '1') == '2' && !is_search()) {
    return;
}

$torfa_footer_copyright = get_theme_mod('footer_copyright');
if (!$torfa_footer_copyright && get_theme_mod('footer_copyright_automated', '1') == '1') {
    $torfa_footer_copyright = sprintf(
        '%s %s %s. %s',
        '©',
        date('Y'),
        get_bloginfo('name'),
        esc_html__('All rights reserved.', 'torfa')
    );
}

// Social Media
$torfa_social_media_visibility = torfa_inherit_option('footer_social_media_visibility', 'footer_social_media_visibility', '1');
$torfa_social_media_enabled = get_theme_mod('footer_social_media_enabled', ['facebook', 'twitter', 'dribbble', 'pinterest', 'linkedin']);

if ($torfa_social_media_visibility == '2' && empty($torfa_footer_copyright)) {
    return;
} 

// Alignment
if (torfa_inherit_option('footer_copyright_alignment', 'footer_copyright_alignment', '1') == '1') {
    $torfa_footer_row = 'row';
    $torfa_copyright_class = 'l-primary-footer__copyright__text';
    $torfa_social_media_class = 'm-social-media l-primary-footer__copyright__social-media h-align-right';
} else {
    $torfa_footer_row = 'row flex-row-reverse';
    $torfa_copyright_class = 'l-primary-footer__copyright__text h-align-right';
    $torfa_social_media_class = 'l-primary-footer__copyright__social-media';
}
?>
<div class="l-primary-footer__copyright">
    <div class="container">
        <div class="l-primary-footer__copyright__space">
            <div class="<?php echo esc_attr($torfa_footer_row) ?> d-flex align-items-center">
                <div class="col-sm-6">
                    <div class="<?php echo esc_attr($torfa_copyright_class) ?>">
                        <?php echo wpautop(wp_kses_post($torfa_footer_copyright)) ?>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="<?php echo esc_attr($torfa_social_media_class) ?>">
                        <?php torfa_social_media($torfa_social_media_visibility, $torfa_social_media_enabled) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>