<?php
/**
 * Footer Widgets
 */
$torfa_footer_widgets_class = ['l-primary-footer__widgets'];
$torfa_active_sidebars = is_active_sidebar('sidebar-footer-1') || is_active_sidebar('sidebar-footer-2') || is_active_sidebar('sidebar-footer-3') || is_active_sidebar('sidebar-footer-4') || is_active_sidebar('sidebar-footer-5') || is_active_sidebar('sidebar-footer-6');

if (torfa_inherit_option('footer_widgets', 'footer_widgets', '1') == '2' || $torfa_active_sidebars == false) {
    return;
}

/**
 * Columns
 */
$torfa_widgets_columns = torfa_inherit_option('footer_widgets_columns', 'footer_widgets_columns', '4');

switch ($torfa_widgets_columns) {
    case '1':
        $torfa_item_class = 'col-sm-12';
        break;
    case '2':
        $torfa_item_class = 'col-sm-6';
        break;
    case '3':
        $torfa_item_class = 'col-sm-6 col-md-4';
        break;
    default:
        $torfa_item_class = 'col-sm-6 col-md-3';
        break;
    case '5':
        $torfa_item_class = 'col-sm-6 col-md-4 a-col-5';
        break;
    case '6':
        $torfa_item_class = 'col-sm-6 col-md-4 col-lg-2';
        break;
}
/**
 * Mobile Visibility
 */
if (torfa_inherit_option('footer_mobile_visibility', 'footer_mobile_visibility', '1') == '2') {
    $torfa_footer_widgets_class[] = 'd-none d-sm-none d-md-block';
}
?>
<div class="<?php echo esc_attr(implode(' ', $torfa_footer_widgets_class)) ?>">
   <div class="container">
        <div class="l-primary-footer__widgets__space">
            <div class="row">
                <?php for ($i = 1; $i <= $torfa_widgets_columns; $i++) { ?>
                    <div class="<?php echo esc_attr($torfa_item_class) ?>">
                        <?php is_active_sidebar('sidebar-footer-' . $i) ? dynamic_sidebar('sidebar-footer-' . $i) : ''; ?>
                    </div>
                <?php } ?>
            </div>
        </div>
   </div>
</div>