<?php 
/**
 * Taxonomy Hero
 * 
 * It is called on each taxonomy,
 * the options can be set from customizer
 * or in each taxonomy individually.
 */
$torfa_hero_class = ['o-hero__header__image'];
$torfa_hero_content_class = ['o-hero__content', 'align-self-center'];
$torfa_hero_style = $torfa_hero_height = $torfa_hero_title_style = $torfa_hero_subtitle_style = [];

/**
 * Queried Object
 */
 if (class_exists('WooCommerce') && is_shop()) {
    $queried_object = wc_get_page_id('shop');
} else if (is_tax() && isset(get_queried_object()->term_id)) {
    $queried_object = 'term_' . get_queried_object()->term_id;
} else {
    $queried_object = get_queried_object();
}

/**
 * Visibility
 */
if (torfa_inherit_option('hero_visibility', 'hero_visibility', '2') == '2') {
    return;
}

/**
 * Container
 */
if (torfa_inherit_option('hero_container', 'hero_container', '1') == '2') {
    $torfa_hero_content_class[] = 'h-wide-container';
}

/**
 * Alignment
 */
switch (torfa_inherit_option('hero_alignment', 'hero_alignment', '2')) {
    case '1':
        $torfa_hero_content_class[] = 'h-align-left';
        break;
    default:
        $torfa_hero_content_class[] = 'h-align-center';
        break;
    case '3':
        $torfa_hero_content_class[] = 'h-align-right';
        break;
}

/**
 * Height
 */
if (get_field('hero_height', $queried_object) == '2' && get_field('hero_custom_height', $queried_object)) {
    $torfa_hero_custom_height = get_field('hero_custom_height', $queried_object);
} else {
    $torfa_hero_custom_height = get_theme_mod('hero_height', '45vh');
}

if ($torfa_hero_custom_height) {
    $torfa_hero_height[] = 'height: '. $torfa_hero_custom_height .'';
}

/**
 * Image
 */
$torfa_hero_image = torfa_inherit_option('hero_image', 'hero_image', '1');

// Increase the number for 1, because the taxonomies doesn't have the option use the post/page featured image
if (get_field('hero_image', $queried_object) > 1 && class_exists('WooCommerce') && !is_shop()) {
    $torfa_hero_image++;
}

if (class_exists('WooCommerce') && is_shop()) {
    $torfa_hero_custom_image = get_field('hero_image', $queried_object) == '3' ? get_field('hero_custom_image', $queried_object) : get_theme_mod('hero_custom_image');
} else {
    $torfa_hero_custom_image = get_field('hero_image', $queried_object) == '2' ? get_field('hero_custom_image', $queried_object) : get_theme_mod('hero_custom_image');
}
 
if ($torfa_hero_image == '2' && $torfa_hero_custom_image) {
    $torfa_hero_style[] = 'background-image: url('. wp_get_attachment_url($torfa_hero_custom_image) .')';
} else {
    $torfa_hero_class[] = 'o-hero__header--no-image';
}

/**
 * Image Repeat
 */
switch (torfa_inherit_option('hero_image_repeat', 'hero_image_repeat', '1')) {
    case '1':
        $torfa_hero_style[] = 'background-repeat: no-repeat';
        break;
    case '2':
        $torfa_hero_style[] = 'background-repeat: repeat-all';
        break;
    case '3':
        $torfa_hero_style[] = 'background-repeat: repeat-x';
        break;
    case '4':
        $torfa_hero_style[] = 'background-repeat: repeat-y';
        break;
}

/**
 * Image Attachment
 */
$hero_image_attachment = torfa_inherit_option('hero_image_attachment', 'hero_image_attachment', '1');

if ($hero_image_attachment == '2') {
    $torfa_hero_style[] = 'background-attachment: fixed';
} elseif ($hero_image_attachment == '3') {
    $torfa_hero_style[] = 'background-attachment: local';    
}

/**
 * Image Position
 */
switch(torfa_inherit_option('hero_image_position', 'hero_image_position', '5')) {
    case '1':
        $torfa_hero_style[] = 'background-position: left top';
        break;
    case '2':
        $torfa_hero_style[] = 'background-position: left center';
        break;
    case '3':
        $torfa_hero_style[] = 'background-position: left bottom';
        break;
    case '4':
        $torfa_hero_style[] = 'background-position: center top';
        break;
     case '5':
        $torfa_hero_style[] = 'background-position: center center';
        break;
    case '6':
        $torfa_hero_style[] = 'background-position: center bottom';
        break;
    case '7':
        $torfa_hero_style[] = 'background-position: right top';
        break;
    case '8':
        $torfa_hero_style[] = 'background-position: right center';
        break;
    case '9':
        $torfa_hero_style[] = 'background-position: right bottom';
        break;
}

/**
 * Image Size
 */
switch(torfa_inherit_option('hero_image_size', 'hero_image_size', '2')) {
    case '2':
        $torfa_hero_style[] = '-webkit-background-size: cover; -moz-background-size: cover; background-size: cover;';
        break;
    case '3':
        $torfa_hero_style[] = '-webkit-background-size: contain; -moz-background-size: contain; background-size: contain;';
        break;
    case '4':
        $torfa_hero_style[] = '-webkit-background-size: initial; -moz-background-size: initial; background-size: initial;';
        break;
}

/**
 * Overlay
 */
$torfa_hero_image_overlay = torfa_inherit_option('hero_image_overlay', 'hero_image_overlay', '2');
$torfa_hero_image_overlay_opacity = (get_field('hero_image_overlay', $queried_object) == '2') ? get_field('hero_image_overlay_opacity', $queried_object) : get_theme_mod('hero_image_overlay_opacity');
$torfa_hero_image_overlay_color = (get_field('hero_image_overlay', $queried_object) == '2') ? get_field('hero_image_overlay_color', $queried_object) : get_theme_mod('hero_image_overlay_color');
$torfa_hero_image_overlay_style = [];

if ($torfa_hero_image_overlay == '1') {
    if ($torfa_hero_image_overlay_opacity) {
        $torfa_hero_image_overlay_style[] = 'opacity: '. $torfa_hero_image_overlay_opacity .'';
    }   
    if ($torfa_hero_image_overlay_color) {
        $torfa_hero_image_overlay_style[] = 'background-color: '. $torfa_hero_image_overlay_color .'';       
    }     
}

/**
 * Title
 */
$torfa_hero_title = torfa_inherit_option('hero_title', 'hero_title', '1');
$torfa_hero_custom_title = (get_field('hero_title', $queried_object) == '3') ? get_field('hero_custom_title', $queried_object) : get_theme_mod('hero_custom_title');
$torfa_hero_title_markup = '';
$torfa_hero_title_class = 'o-hero__content__title';

if (class_exists('WooCommerce') && is_shop()) {
    $torfa_hero_title_markup = woocommerce_page_title(false);
} elseif (is_date()) {
    $torfa_hero_title_markup = get_the_date();
} elseif (is_author()) {
    $torfa_hero_title_markup = get_the_author();
} elseif ($torfa_hero_title == '1') {
    $torfa_hero_title_markup = single_term_title('', false);
} elseif ($torfa_hero_title == '2' && $torfa_hero_custom_title) {
    $torfa_hero_title_markup = $torfa_hero_custom_title;
} 

/**
 * Title Animation
 */
if (torfa_inherit_option('hero_title_animation', 'hero_title_animation', '2') == '2') {
    $torfa_hero_title_class .= ' h-fadeInNeuron wow';    
} elseif (torfa_inherit_option('hero_title_animation', 'hero_title_animation', '2') == '3') {
    $torfa_hero_title_class .= ' h-fadeInUpNeuron wow';    
}

/**
 * Title Color
 */
$torfa_hero_title_color = get_field('hero_title_color', $queried_object) == '1' ? get_theme_mod('hero_title_color', '#232931') : get_field('hero_title_color_custom', $queried_object);
$torfa_hero_title_color && $torfa_hero_title_color != '#232931' ? $torfa_hero_title_style[] = 'color: '. $torfa_hero_title_color .'' : '';

/**
 * Subtitle
 */
$torfa_hero_subtitle_class = 'o-hero__content__subtitle';

if (get_field('hero_subtitle', $queried_object) == '1') {
    $torfa_hero_custom_subtitle = get_theme_mod('hero_subtitle');
} else {
    $torfa_hero_custom_subtitle = get_field('hero_custom_subtitle', $queried_object);
}

/**
 * Subtitle Animation
 */
if (torfa_inherit_option('hero_subtitle_animation', 'hero_subtitle_animation', '2') == '2') {
    $torfa_hero_subtitle_class .= ' h-fadeInNeuron wow';    
} elseif (torfa_inherit_option('hero_subtitle_animation', 'hero_subtitle_animation', '2') == '3') {
    $torfa_hero_subtitle_class .= ' h-fadeInUpNeuron wow';    
}

/**
 * Subtitle Color
 */
$torfa_hero_subtitle_color = get_field('hero_subtitle_color', $queried_object) == '1' ? get_theme_mod('hero_subtitle_color', '#858585') : get_field('hero_subtitle_color_custom', $queried_object);
$torfa_hero_subtitle_color && $torfa_hero_subtitle_color != '#858585' ? $torfa_hero_subtitle_style[] = 'color: '. $torfa_hero_subtitle_color .'' : '';

/**
 * Output the Hero
 */
echo sprintf(
    '<div class="o-hero d-flex" %s>
        <div class="o-hero__header">
            <div class="%s" %s></div>
            %s
        </div>
        <div class="%s">
            <div class="container">%s %s</div>
        </div>
    </div>',
    $torfa_hero_custom_height ? 'style="'. implode(';', $torfa_hero_height) .'"' : '',
    implode(' ', $torfa_hero_class),
    $torfa_hero_style ? 'style="'. implode(';', $torfa_hero_style) .'"' : '',
    $torfa_hero_image_overlay == '1' ? '<div class="o-hero__header__overlay" style="'. implode(';', $torfa_hero_image_overlay_style) .'"></div>' : '',
    implode(' ', $torfa_hero_content_class),
    $torfa_hero_title_markup ? '<div '. ($torfa_hero_title_style ? 'style="'. implode(';', $torfa_hero_title_style) .'"' : '') . ($torfa_hero_title_class ? ' class="'. $torfa_hero_title_class .'"' : '') .'>'. $torfa_hero_title_markup .'</div>' : '',
    $torfa_hero_custom_subtitle ? '<div '. ($torfa_hero_subtitle_style ? 'style="'. implode(';', $torfa_hero_subtitle_style) .'"' : '') . ($torfa_hero_subtitle_class ? ' class="'. $torfa_hero_subtitle_class .'"' : '') .'>'. $torfa_hero_custom_subtitle .'</div>' : ''
);