<?php
/**
 * Portfolio Item Gallery
 */

/**
 * Columns
 * 
 * Change gallery items columns
 * via customizer or individually.
 */
switch (torfa_inherit_option('portfolio_item_gallery_columns', 'portfolio_item_gallery_columns', '1')) {
    default:
        $torfa_gallery_item_column = 'col-12';
        break;
    case '2':
        $torfa_gallery_item_column = 'col-sm-6';
        break;
    case '3':
        $torfa_gallery_item_column = 'col-sm-6 col-md-4';
        break;
    case '4':
        $torfa_gallery_item_column = 'col-sm-6 col-md-3';
        break;
}

/**
 * Animation & WOW Delay
 */
$torfa_portfolio_item_gallery_animation = torfa_inherit_option('portfolio_item_gallery_animation', 'portfolio_item_gallery_animation', '2');
$torfa_portfolio_item_holder_class = 'p-portfolio-gallery__item';

if ($torfa_portfolio_item_gallery_animation == '2' || $torfa_portfolio_item_gallery_animation == '4') {
    $torfa_portfolio_item_holder_class .= ' h-fadeInNeuron wow';    
} elseif ($torfa_portfolio_item_gallery_animation == '3' || $torfa_portfolio_item_gallery_animation == '5') {
    $torfa_portfolio_item_holder_class .= ' h-fadeInUpNeuron wow';
}

$torfa_data_wow_delay = false;
$torfa_data_wow_seconds = 0;

if ($torfa_portfolio_item_gallery_animation == '4' || $torfa_portfolio_item_gallery_animation == '5') {
    $torfa_data_wow_delay = true;
}

if (have_rows('portfolio_item_gallery')) :
?>
<div class="p-portfolio-gallery">
    <div class="row masonry">
        <?php while (have_rows('portfolio_item_gallery')) : the_row(); ?>
            <?php 
            /**
             * WOW Animation
             */
            $torfa_data_wow_seconds == 12 ? $torfa_data_wow_seconds = 0 : '';
            $torfa_wow_holder = "data-wow-delay=". $torfa_data_wow_seconds/10 ."s";
            ?>
            <div class="selector <?php echo esc_attr($torfa_gallery_item_column) ?>">
                <div class="h-lightbox <?php echo esc_attr($torfa_portfolio_item_holder_class) ?>" <?php echo esc_attr($torfa_data_wow_delay === true && $torfa_data_wow_seconds ? $torfa_wow_holder : '') ?>>
                    <?php if (get_row_layout() == 'portfolio_item_gallery_image') : ?>
                        <a class="h-calculated-image h-lightbox-link" data-mfp-src="<?php echo esc_url(get_sub_field('portfolio_item_gallery_image_obj')['url']) ?>" style="<?php echo esc_attr(torfa_image_calculation(get_sub_field('portfolio_item_gallery_image_obj')['id'])) ?>">
                            <img src="<?php echo esc_url(get_sub_field('portfolio_item_gallery_image_obj')['url']) ?>" alt="<?php echo esc_url(get_sub_field('portfolio_item_gallery_image_obj')['url']) ?>">
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        <?php $torfa_data_wow_seconds = $torfa_data_wow_seconds + 2; endwhile; ?>
    </div>
</div>
<?php
endif;