<?php
/**
 * Meta Inside
 * 
 * the template will called incase
 * the user has selected meta inside
 * as shop type.
 */
global $product;

$torfa_shop_meta_inside_class = 'o-neuron-hover l-woocommerce-wrapper__product';
$torfa_hover_holder_body_class = ['o-neuron-hover-holder__body', 'd-flex'];
$torfa_hover_holder_button_holder_class = ['o-neuron-hover-holder__button-holder'];

/**
 * Hover Visibility
 */
if ($neuron_posts_hover_visibility == 'show') {
    $torfa_shop_meta_inside_class .= ' o-neuron-hover--meta-inside';
} 

/**
 * Hover Animation
 */
if ($neuron_posts_hover_visibility != 'hide' && $neuron_posts_hover_animation) {
    $torfa_shop_meta_inside_class .= ' o-neuron-hover--' . $neuron_posts_hover_animation;
}

/**
 * Hover Active
 */
$torfa_hover_holder_class = ['o-neuron-hover-holder'];
$neuron_posts_style_hover_active == 'yes' ? $torfa_hover_holder_class[] = 'o-neuron-hover-holder--active' : '';

/**
 * Hover Meta
 */
$torfa_hover_holder_body_class[] = $neuron_posts_style_hover_meta_vertical_alignment ? 'align-items-'. $neuron_posts_style_hover_meta_vertical_alignment .'' : 'align-items-center';

/**
 * Hover Icon Alignment
 */
switch ($neuron_posts_style_hover_button_vertical_alignment) {
    case 'start':
        $torfa_hover_holder_button_holder_class[] = 'top';
        break;
    case 'center':
        $torfa_hover_holder_button_holder_class[] = 'vertical-center';
        break;
    default:
        $torfa_hover_holder_button_holder_class[] = 'bottom';
        break;
}
?>
<div class="<?php echo esc_attr($torfa_shop_meta_inside_class) ?>">
    <div class="<?php echo esc_attr(implode(' ', $torfa_hover_holder_class)) ?>">
        <div class="o-neuron-hover-holder__header">
            <a href="<?php the_permalink() ?>" class="o-neuron-hover-holder__header__media">
                <?php if ($neuron_posts_carousel_height == 'full') : ?>
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="h-full-height-image h-background-image-style" style="background-image: url(<?php the_post_thumbnail_url() ?>)"></div>
                    <?php else : ?>
                        <div class="h-full-height-image h-background-image-style" style="background-image: url(<?php echo esc_url(TORFA_THEME_PLACEHOLDER) ?>)"></div>
                    <?php endif; ?>
                <?php elseif (has_post_thumbnail()) : ?>
                    <div class="h-calculated-image" style="<?php echo esc_attr(torfa_thumbnail_calculation($neuron_posts_thumbnail_resizer)) ?>">
                        <?php 
                        /**
                         * Thumbnail Sizes
                         * 
                         * It inherits the option via set query var.
                         */
                        if ($neuron_posts_thumbnail_resizer) {
                            the_post_thumbnail($neuron_posts_thumbnail_resizer);
                        } else {
                            the_post_thumbnail();
                        }
                        ?>
                    </div>
               <?php else : ?>
                    <div class="h-calculated-image" style="padding-bottom: 100%">
                        <?php echo wc_placeholder_img('full'); ?>
                    </div>
                <?php endif;?>
            </a>
            <?php
            if (!$product->is_in_stock()) {
                echo '<div class="a-woo-badge a-woo-badge--red-color">' . esc_html__('Out of Stock', 'torfa') . '</div>';
            } elseif ($product->is_on_sale()) {
                echo '<div class="a-woo-badge a-woo-badge--theme-color">' . esc_html__('Sale!', 'torfa') . '</div>';
            }
            ?>
            <?php if ($neuron_posts_hover_visibility != 'hide') : ?>
                <div class="o-neuron-hover-holder__header__overlay"></div>
            <?php endif; ?>
        </div>
        <?php if ($neuron_posts_hover_visibility != 'hide') : ?>
            <div class="<?php echo esc_attr(implode(' ', $torfa_hover_holder_body_class)) ?>">
                <div class="o-neuron-hover-holder__body__inner">
                    <div class="o-neuron-hover-holder__body-meta">
                        <?php if ($neuron_posts_meta_title == 'yes') : ?>
                            <h4 class="o-neuron-hover-holder__body-meta__title"><a href="<?php the_permalink() ?>"><?php echo esc_attr($product->get_title()); ?></a></h4>
                        <?php endif; ?>
                        <?php if ($neuron_posts_meta_price == 'yes') : ?>
                            <div class="o-neuron-hover-holder__body-meta__subtitle o-neuron-hover-holder__body-meta__price"><?php wc_get_template_part('woocommerce/loop/price') ?></div>
                        <?php endif; ?>
                    </div>
                    <a href="<?php the_permalink() ?>"></a>
                </div>
            </div>
            <?php if ($neuron_posts_style_hover_button == 'yes') : ?>
                <div class="<?php echo esc_attr(implode(' ', $torfa_hover_holder_button_holder_class)) ?>">
                    <?php wc_get_template_part('woocommerce/loop/add-to-cart') ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>