<?php
/**
 * Portfolio Categories 
 */
$portfolio_categories = get_the_terms(get_the_ID(), 'portfolio_category');

if (!$portfolio_categories) {
    return;
}
?>
<div class="o-neuron-hover__body-meta__subtitle o-portfolio-item__category-holder">
    <div class="o-portfolio-item__category a-separator">
        <ul>
            <?php foreach ($portfolio_categories as $category) : ?>
                <li><a href="<?php echo esc_url(get_category_link($category->term_id)) ?>"><?php echo esc_attr($category->name) ?></a></li>
            <?php endforeach; ?>
        </ul>
    </div>
</div>