<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header(); 

get_template_part('templates/hero/standard');

/**
 * Sidebar
 */
$torfa_sidebar_option = torfa_inherit_option('product_sidebar', 'product_sidebar', '3');
$torfa_row_class = 'row';
$torfa_product_class = 'col-lg-8';
$torfa_sidebar_class = 'col-lg-4';

if ($torfa_sidebar_option == '1') {
    $torfa_row_class .= ' flex-row-reverse';
} elseif ($torfa_sidebar_option == '3') {
	$torfa_product_class = 'col-12';
	$torfa_sidebar_class = 'h-display-none';
}

/**
 * Breadcrumb
 */
$torfa_page_breadcrumb = torfa_inherit_option('general_breadcrumb', 'breadcrumbs_product_visibility', '2');
torfa_breadcrumbs($torfa_page_breadcrumb, get_theme_mod('breadcrumbs_separator'));

do_action('torfa_open_container');
?>
<div class="l-woocommerce-wrapper h-large-top-padding h-large-bottom-padding">
	<div class="<?php echo esc_attr($torfa_row_class) ?>">
		<div class="<?php echo esc_attr($torfa_product_class) ?>">
			<?php 
			while (have_posts()) {
				the_post();
				wc_get_template_part('content', 'single-product');
			}
			?>
		</div>
		<?php if ($torfa_sidebar_option != '3') : ?>
			<div class="<?php echo esc_attr($torfa_sidebar_class) ?>">
				<div class="o-main-sidebar">
					<?php get_sidebar('shop') ?>
				</div>
			</div>
		<?php endif; ?>
	</div>
</div>
<?php 
do_action('torfa_close_container');

get_template_part('templates/shop/product/navigation');

get_footer();
