<?php 
/**
 * Default Logo
 */
$torfa_logo_display = $torfa_light_logo_display = $torfa_logo_style = [];

/**
 * Logos
 */
$torfa_dark_logo = get_theme_mod('header_dark_logo');
$torfa_light_logo = get_theme_mod('header_light_logo');
$torfa_text_logo = get_theme_mod('header_logo_text');
$torfa_custom_dark_logo = get_field('header_dark_logo');
$torfa_custom_light_logo = get_field('header_light_logo');

/**
 * Logo Attributes
 */
$torfa_logo_width = get_theme_mod('header_logo_width');
$torfa_logo_height = get_theme_mod('header_logo_height');
$torfa_logo_custom_width = get_field('header_logo_width');
$torfa_logo_custom_height = get_field('header_logo_height');
$torfa_logo_text_size = get_theme_mod('header_logo_text_size');

/**
 * Logo Classes & Extensions
 */
$torfa_logo_class = 'a-logo a-logo--image';
$torfa_dark_logo_img_class = 'a-logo--image__inner a-logo--image__inner--dark';
$torfa_light_logo_img_class = 'a-logo--image__inner a-logo--image__inner--light';
$torfa_logo_ext = 'png';

/**
 * Dark Logo
*/
if ($torfa_custom_dark_logo) {
    $torfa_logo_display = $torfa_custom_dark_logo;  
} elseif ($torfa_custom_light_logo) {
    $torfa_logo_display = $torfa_custom_light_logo;  
} elseif ($torfa_dark_logo) {
    $torfa_logo_display = $torfa_dark_logo;  
} elseif ($torfa_light_logo) {
    $torfa_logo_display = $torfa_light_logo;  
} else {
    $torfa_logo_class = 'a-logo a-logo--text';
}

/**
 * Light Logo
*/
if ($torfa_custom_light_logo) {
    $torfa_light_logo_display = $torfa_custom_light_logo;
} elseif ($torfa_light_logo) {
    $torfa_light_logo_display = $torfa_light_logo;
}

/**
 * Logo Attributes
*/
if ($torfa_logo_display) {
    if ($torfa_logo_custom_width) {
        $torfa_logo_style[] = 'width: '. $torfa_logo_custom_width .'px';
    } elseif ($torfa_logo_width) {
        $torfa_logo_style[] = 'width: '. $torfa_logo_width .'px';
    } elseif (!strpos(wp_get_attachment_url($torfa_logo_display), '.svg')) {
        $torfa_logo_style[] = 'width: '. wp_get_attachment_metadata($torfa_logo_display)['width'] .'px';
    }
    
    if ($torfa_logo_custom_height) {
        $torfa_logo_style[] = 'height: '. $torfa_logo_custom_height .'px';
    } elseif ($torfa_logo_height) {
        $torfa_logo_style[] = 'height: '. $torfa_logo_height .'px';
    } elseif (!strpos(wp_get_attachment_url($torfa_logo_display), '.svg')) {
        $torfa_logo_style[] = 'height: '. wp_get_attachment_metadata($torfa_logo_display)['height'] .'px';
    }
}

/**
 * Logo Text Size
*/
if ($torfa_logo_text_size && !$torfa_logo_display && !$torfa_light_logo_display) {
    $torfa_logo_style[] = 'font-size: '. $torfa_logo_text_size .'px';
}

/**
 * Logo Type
*/
if ($torfa_logo_display && wp_check_filetype(wp_get_attachment_url($torfa_logo_display))['ext'] == 'svg') {
    $torfa_dark_logo_img_class .= ' style-svg';
} 

if ($torfa_light_logo_display && wp_check_filetype(wp_get_attachment_url($torfa_light_logo_display))['ext'] == 'svg') {
    $torfa_light_logo_img_class .= ' style-svg';
}

?>
<div class="<?php echo esc_attr($torfa_logo_class) ?>">
    <a href="<?php echo esc_url(home_url('/')); ?>" style="<?php echo esc_attr(implode(';', $torfa_logo_style)) ?>">
        <?php
        // Dark Logo
        if ($torfa_logo_display) {
            echo wp_get_attachment_image($torfa_logo_display, 'full', '', array('class' => $torfa_dark_logo_img_class));
        } elseif ($torfa_text_logo) {
            echo esc_attr($torfa_text_logo);
        } else {
            echo esc_attr(bloginfo('name'));
        }

        // Light Logo
        if ($torfa_light_logo_display) {
            echo wp_get_attachment_image($torfa_light_logo_display, 'full', '', array('class' => $torfa_light_logo_img_class));
        } 
        ?>
    </a>
</div>