<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined('ABSPATH') || exit;

get_header();

get_template_part('templates/hero/taxonomy');

global $torfa_data_wow_seconds, $torfa_data_wow_delay;

/**
 * Type
 */
$torfa_shop_type = get_theme_mod('shop_type', 'meta-inside');
if ($torfa_shop_type == 'meta-inside') {
	$torfa_products_holder = 'l-posts-wrapper l-posts-wrapper--meta-inside l-woocommerce-wrapper__products-holder l-woocommerce-wrapper__products-holder--meta-inside';
} else {
	$torfa_products_holder = 'l-posts-wrapper l-posts-wrapper--meta-outside l-woocommerce-wrapper__products-holder l-woocommerce-wrapper__products-holder--meta-outside';
}

/**
 * Sidebar
 */
$torfa_row_class = 'row';
$torfa_products_class = 'col-lg-8';
$torfa_sidebar_class = 'col-lg-4';

if (get_theme_mod('shop_sidebar', '2') == '1') {
    $torfa_row_class .= ' flex-row-reverse';
} elseif (get_theme_mod('shop_sidebar', '2') == '3') {
    $torfa_products_class = 'col-12';
    $torfa_sidebar_class = 'h-display-none';
}

/**
 * Animation
 */
$torfa_data_wow_delay = false;
$torfa_data_wow_seconds = 0;

if (get_theme_mod('shop_animation', 'fade-in') == 'fade-in-delay' || get_theme_mod('shop_animation', 'fade-in') == 'fade-in-up-delay') {
    $torfa_data_wow_delay = true;
}

/**
 * Meta
 */
set_query_var('neuron_posts_meta_thumbnail', 'yes');
set_query_var('neuron_posts_meta_title', 'yes');
set_query_var('neuron_posts_meta_price', 'yes');
set_query_var('neuron_posts_meta_results_count', 'yes');
set_query_var('neuron_posts_carousel_height', 'auto');
set_query_var('neuron_posts_style_hover_active', 'no');
set_query_var('neuron_posts_thumbnail_resizer', '');
/**
 * Hover
 */
set_query_var('neuron_posts_style_hover_button', 'yes');
set_query_var('neuron_posts_style_hover_button_vertical_alignment', 'end');
set_query_var('neuron_posts_style_hover_meta_vertical_alignment', 'center');

/**
 * Hover Visibility and Hover Animation
 */
set_query_var('neuron_posts_hover_visibility', 'show');
set_query_var('neuron_posts_hover_animation', 'translate');

torfa_breadcrumbs(get_theme_mod('breadcrumbs_shop_visibility', '2'), get_theme_mod('breadcrumbs_separator'));

do_action('torfa_open_container');
?>
<div class="l-woocommerce-wrapper h-large-top-padding h-large-bottom-padding">
	<div class="<?php echo esc_attr($torfa_row_class) ?>">
		<div class="<?php echo esc_attr($torfa_products_class) ?>">
			<div class="l-woocommerce-wrapper__top-bar h-medium-bottom-padding">
				<div class="row">
					<div class="col-sm-6">
						<?php woocommerce_result_count(); ?>
					</div>
					<div class="col-sm-6">
						<?php woocommerce_catalog_ordering(); ?>
					</div>
				</div>
			</div>
			<div class="<?php echo esc_attr($torfa_products_holder) ?>">
				<div class="row masonry">
					<?php while (have_posts()) : the_post(); ?>
						<?php
						do_action('woocommerce_shop_loop');

						wc_get_template_part('content', 'product');

						$torfa_data_wow_seconds = $torfa_data_wow_seconds + 2;
						$torfa_data_wow_seconds == 12 ? $torfa_data_wow_seconds = 0 : '';
						?>
					<?php endwhile; ?>
				</div>
			</div>
		</div>
       <?php if (get_theme_mod('shop_sidebar', '2') !== '3') : ?>
			<div class="<?php echo esc_attr($torfa_sidebar_class) ?>">
				<div class="o-main-sidebar">
					<?php get_sidebar('shop') ?>
				</div>
			</div>
		<?php endif; ?>
	</div>
</div>
<?php
do_action('torfa_close_container');

neuron_pagination();

get_footer();