<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     10.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $torfa_data_wow_seconds, $torfa_data_wow_delay;

/**
 * Related Products Visibility
 */
if (torfa_inherit_option('product_related', 'product_related', '1') == '2') {
	return;
}

/**
 * Related Products Columns
 */
if ($related_products) {
	switch (torfa_inherit_option('product_related_count', 'product_related_count', '4')) {
		case '1':
			unset($related_products[1], $related_products[2], $related_products[3]);
			break;
		case '2':
			unset($related_products[2], $related_products[3]);
			break;
		case '3':
			unset($related_products[3]);
			break;
	}
}

/**
 * Animation
 */
$torfa_data_wow_delay = false;
$torfa_data_wow_seconds = 0;

if (get_theme_mod('shop_animation', 'fade-in') == 'fade-in-delay' || get_theme_mod('shop_animation', 'fade-in') == 'fade-in-up-delay') {
    $torfa_data_wow_delay = true;
}

if ( $related_products ) :
	/**
	 * Ensure all images of related products are lazy loaded by increasing the
	 * current media count to WordPress's lazy loading threshold if needed.
	 * Because wp_increase_content_media_count() is a private function, we
	 * check for its existence before use.
	 */
	if ( function_exists( 'wp_increase_content_media_count' ) ) {
		$content_media_count = wp_increase_content_media_count( 0 );
		if ( $content_media_count < wp_omit_loading_attr_threshold() ) {
			wp_increase_content_media_count( wp_omit_loading_attr_threshold() - $content_media_count );
		}
	}
	?>
	<section class="related products l-posts-wrapper l-posts-wrapper--meta-outside l-woocommerce-wrapper__products-holder l-woocommerce-wrapper__products-holder--meta-outside">
		<?php
		$heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Related products', 'torfa' ) );

		if ( $heading ) :
			?>
			<h2 class="h3"><?php echo esc_html( $heading ); ?></h2>
		<?php endif; ?>
		<div class="row masonry">
			<?php foreach ($related_products as $related_product) : ?>
				<?php
				$post_object = get_post($related_product->get_id());
				setup_postdata($GLOBALS['post'] = $post_object); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found
				wc_get_template_part('content', 'product');
				$torfa_data_wow_seconds = $torfa_data_wow_seconds + 2;
				$torfa_data_wow_seconds == 12 ? $torfa_data_wow_seconds = 0 : '';
                ?>
			<?php endforeach; ?>
		</div>
	</section>
	<?php
endif;

wp_reset_postdata();
