<?php

defined( 'ABSPATH' ) || exit;

$patterns = [];

$patterns['faq-1'] = [];
$patterns['faq-1']['content'] = <<<CONTENT
[vc_row remove_bottom_col_margin="true" el_class="wpex-py-60"][vc_column][vcex_heading text="Frequently Asked Questions" text_align="center" tag="h2" font_size="2xl" font_weight="700" bottom_margin="20px"][vc_column_text bottom_margin="60px" width="650px" align="center" text_align="center" el_class="wpex-text-pretty"]Find answers to common questions quickly and easily. Learn more about our services, policies, and support options to get the help you need.[/vc_column_text][vcex_grid_container columns_lg="2" gap="40px"][vcex_teaser heading="What services do you offer?" heading_type="h3" heading_size="lg"]We offer a range of services, including web development, digital marketing, and business consulting tailored to help your brand grow.[/vcex_teaser][vcex_teaser heading="How can I get started with your services?" heading_type="h3" heading_size="lg"]Getting started is simple! Reach out through our contact form or book a free consultation to discuss your needs.[/vcex_teaser][vcex_teaser heading="Do you offer customized solutions?" heading_type="h3" heading_size="lg"]Yes, we provide fully customized solutions to fit the unique requirements of your business or project.[/vcex_teaser][vcex_teaser heading="How long does it take to see results?" heading_type="h3" heading_size="lg"]The timeframe varies based on the type of service. For most projects, initial results may be visible within a few weeks, while full outcomes take longer.[/vcex_teaser][vcex_teaser heading="Is support available after the service is completed?" heading_type="h3" heading_size="lg"]Yes, we offer ongoing support and maintenance packages to ensure your success continues well after project completion.[/vcex_teaser][vcex_teaser heading="What payment methods do you accept?" heading_type="h3" heading_size="lg"]We accept all major credit cards, PayPal, and bank transfers for your convenience. Additional options may be available upon request.[/vcex_teaser][/vcex_grid_container][/vc_column][/vc_row]
CONTENT;

$patterns['faq-2'] = [];
$patterns['faq-2']['content'] = <<<CONTENT
[vc_row column_spacing="60" el_class="wpex-pt-60"][vc_column width="1/3"][vcex_heading text="Frequently asked questions" icon_position="right" icon_side_margin="10px" tag="h2" font_size="3xl" text_balance="true" font_weight="700" icon="question-circle" bottom_margin="15px"][vc_column_text]Find answers to common questions quickly and easily. Learn more about our services, policies, and support options to get the help you need.[/vc_column_text][/vc_column][vc_column width="2/3"][vcex_grid_container columns_lg="" gap="40px"][vcex_teaser heading="What services do you offer?" heading_type="h3" heading_size="lg"]We offer a range of services, including web development, digital marketing, and business consulting tailored to help your brand grow.[/vcex_teaser][vcex_teaser heading="How can I get started with your services?" heading_type="h3" heading_size="lg"]Getting started is simple! Reach out through our contact form or book a free consultation to discuss your needs.[/vcex_teaser][vcex_teaser heading="Do you offer customized solutions?" heading_type="h3" heading_size="lg"]Yes, we provide fully customized solutions to fit the unique requirements of your business or project.[/vcex_teaser][vcex_teaser heading="How long does it take to see results?" heading_type="h3" heading_size="lg"]The timeframe varies based on the type of service. For most projects, initial results may be visible within a few weeks, while full outcomes take longer.[/vcex_teaser][/vcex_grid_container][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]
CONTENT;

$patterns['faq-3'] = [];
$patterns['faq-3']['content'] = <<<CONTENT
[vc_row gap="30" equal_height="yes" css=".vc_custom_1627254934565{margin-top: 40px !important;margin-right: 0px !important;margin-left: 0px !important;}"][vc_column width="2/5"][vcex_image source="external" external_image="{$ph_portrait}"][/vc_column][vc_column width="3/5"][vcex_heading text="Frequently asked questions" icon_position="right" tag="h2" font_size="2xl" font_weight="700" bottom_margin="15px"][vc_column_text bottom_margin="30px"]Find answers to common questions quickly and easily. Learn more about our services, policies, and support options to get the help you need.[/vc_column_text][vcex_toggle_group width="600px"][vcex_toggle heading="What services do you offer?" icon_position="right" content_spacing="" heading_color_hover="accent" heading_color="#000000" heading_font_weight="semibold"]We offer a range of services, including web development, digital marketing, and business consulting tailored to help your brand grow.[/vcex_toggle][vcex_toggle heading="How can I get started with your services?" icon_position="right" content_spacing="" heading_color_hover="accent" heading_color="#000000" heading_font_weight="semibold"]Getting started is simple! Reach out through our contact form or book a free consultation to discuss your needs.[/vcex_toggle][vcex_toggle heading="Do you offer customized solutions?" icon_position="right" content_spacing="" heading_color_hover="accent" heading_color="#000000" heading_font_weight="semibold"]Yes, we provide fully customized solutions to fit the unique requirements of your business or project.[/vcex_toggle][vcex_toggle heading="How long does it take to see results?" icon_position="right" content_spacing="" heading_color_hover="accent" heading_color="#000000" heading_font_weight="semibold"]The timeframe varies based on the type of service. For most projects, initial results may be visible within a few weeks, while full outcomes take longer.[/vcex_toggle][vcex_toggle heading="Is support available after the service is completed?" icon_position="right" content_spacing="" heading_color_hover="accent" heading_color="#000000" heading_font_weight="semibold"]Yes, we offer ongoing support and maintenance packages to ensure your success continues well after project completion.[/vcex_toggle][/vcex_toggle_group][/vc_column][/vc_row]
CONTENT;

$patterns['faq-4'] = [];
$patterns['faq-4']['content'] = <<<CONTENT
[vc_row full_width="stretch_row" remove_bottom_col_margin="true" wpex_bg_color="#3858e9" css=".vc_custom_1626838082392{padding-top: 8% !important;padding-bottom: 10% !important;}"][vc_column][vcex_heading text="Frequently Asked Questions" tag="h2" font_size="2xl" font_weight="700" color="#FFF"][vcex_divider color="rgba(255,255,255,0.7)" margin="top:20px|bottom:50px"][vcex_grid_container columns_lg="2" gap="40px"][vcex_teaser heading="What services do you offer?" heading_type="h3" heading_size="lg" heading_color="#FFF" content_color="#FFFFFF99"]We offer a range of services, including web development, digital marketing, and business consulting tailored to help your brand grow.[/vcex_teaser][vcex_teaser heading="How can I get started with your services?" heading_type="h3" heading_size="lg" heading_color="#FFF" content_color="#FFFFFF99"]Getting started is simple! Reach out through our contact form or book a free consultation to discuss your needs.[/vcex_teaser][vcex_teaser heading="Do you offer customized solutions?" heading_type="h3" heading_size="lg" heading_color="#FFF" content_color="#FFFFFF99"]Yes, we provide fully customized solutions to fit the unique requirements of your business or project.[/vcex_teaser][vcex_teaser heading="How long does it take to see results?" heading_type="h3" heading_size="lg" heading_color="#FFF" content_color="#FFFFFF99"]The timeframe varies based on the type of service. For most projects, initial results may be visible within a few weeks, while full outcomes take longer.[/vcex_teaser][/vcex_grid_container][/vc_column][/vc_row]
CONTENT;

$patterns['faq-5'] = [];
$patterns['faq-5']['content'] = <<<CONTENT
[vc_row remove_bottom_col_margin="true" el_class="wpex-py-60"][vc_column][vcex_heading text="Frequently Asked Questions" bottom_margin="10px" text_align="center" tag="h2" font_size="2xl" font_weight="700"][vcex_divider width="60px" align="center" margin="top:20px|bottom:50px"][vcex_toggle_group max_width="600px" bottom_margin="50px"][vcex_toggle heading="What services do you offer?" icon_type="angle" icon_position="right" heading_tag="h4" heading_font_size="lg"]We offer a range of services, including web development, digital marketing, and business consulting tailored to help your brand grow.[/vcex_toggle][vcex_toggle heading="How can I get started with your services?" icon_type="angle" icon_position="right" heading_tag="h4" heading_font_size="lg"]Getting started is simple! Reach out through our contact form or book a free consultation to discuss your needs.[/vcex_toggle][vcex_toggle heading="Do you offer customized solutions?" icon_type="angle" icon_position="right" heading_tag="h4" heading_font_size="lg"]Yes, we provide fully customized solutions to fit the unique requirements of your business or project.[/vcex_toggle][vcex_toggle heading="How long does it take to see results?" icon_type="angle" icon_position="right" heading_tag="h4" heading_font_size="lg"]The timeframe varies based on the type of service. For most projects, initial results may be visible within a few weeks, while full outcomes take longer.[/vcex_toggle][vcex_toggle heading="Is support available after the service is completed?" icon_type="angle" icon_position="right" heading_tag="h4" heading_font_size="lg"]Yes, we offer ongoing support and maintenance packages to ensure your success continues well after project completion.[/vcex_toggle][vcex_toggle heading="What payment methods do you accept?" icon_type="angle" icon_position="right" heading_tag="h4" heading_font_size="lg"]We accept all major credit cards, PayPal, and bank transfers for your convenience. Additional options may be available upon request.[/vcex_toggle][/vcex_toggle_group][vcex_heading text="Still Have Questions?" bottom_margin="10px" text_align="center" tag="h2" font_size="lg" font_weight="700"][vc_column_text width="500px" align="center" text_align="center"]If you can't find an answer to your question in the FAQ's above, you can always <a href="#">contact us</a> and we'll respond asap.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

$patterns['faq-6'] = [];
$patterns['faq-6']['content'] = <<<CONTENT
[vc_row full_width="stretch_row" remove_bottom_col_margin="true" el_class="wpex-py-60 wpex-surface-2"][vc_column][vcex_heading text="FAQs" text_align="center" tag="h2" font_size="7xl" font_weight="700" line_height="1" bottom_margin="50px"][vcex_grid_container columns_lg="2" gap="35px"][vcex_icon_box heading="How can I get started with your services?" wpex_padding="30px" shadow="shadow-lg" icon="question-circle-o" heading_size="lg" heading_type="h3" heading_weight="600" heading_bottom_margin="10px" classes="wpex-surface-1" icon_size="32px"]Getting started is simple! Reach out through our contact form or book a free consultation to discuss your needs.[/vcex_icon_box][vcex_icon_box heading="Do you offer customized solutions?" wpex_padding="30px" shadow="shadow-lg" icon="question-circle-o" heading_size="lg" heading_type="h3" heading_weight="600" heading_bottom_margin="10px" classes="wpex-surface-1" icon_size="32px"]Yes, we provide fully customized solutions to fit the unique requirements of your business or project.[/vcex_icon_box][vcex_icon_box heading="How long does it take to see results?" wpex_padding="30px" shadow="shadow-lg" icon="question-circle-o" heading_size="lg" heading_type="h3" heading_weight="600" heading_bottom_margin="10px" classes="wpex-surface-1" icon_size="32px"]The timeframe varies based on the type of service. For most projects, initial results may be visible within a few weeks.[/vcex_icon_box][vcex_icon_box heading="What payment methods do you accept?" wpex_padding="30px" shadow="shadow-lg" icon="question-circle-o" heading_size="lg" heading_type="h3" heading_weight="600" heading_bottom_margin="10px" classes="wpex-surface-1" icon_size="32px"]We accept all major credit cards, PayPal, and bank transfers for your convenience. Additional options may be available upon request.[/vcex_icon_box][/vcex_grid_container][/vc_column][/vc_row]
CONTENT;
// IMPORTANT - Space required to prevent HEREDOC errors.

return $patterns;
