<?php

defined( 'ABSPATH' ) || exit;

$patterns = [];

$patterns['statistics-1'] = [];
$patterns['statistics-1']['content'] = <<<CONTENT
[vc_row remove_bottom_col_margin="true" el_class="wpex-py-60"][vc_column][vcex_heading text="Why Choose Company X?" text_align="center" tag="h2" font_size="3xl" bottom_margin="20px"][vc_column_text width="850px" align="center" text_align="center" bottom_margin="60px"]We are committed to delivering exceptional value, tailored solutions, and unparalleled service. Our dedicated team ensures your needs are met with expertise, reliability, and a focus on your success.[/vc_column_text][vcex_grid_container align_items="center" justify_items="center" columns_lg="" columns_md="3" gap="40px"][vcex_milestone number="8" caption="Years in Service" caption_size="1em" number_weight="600" caption_font="500" after="+"][vcex_milestone number="16" caption="Products &amp; Services" caption_size="1em" number_weight="600" caption_font="500" after="+"][vcex_milestone number="200" caption="Happy Clients" after="+" caption_size="1em" number_weight="600" caption_font="500"][/vcex_grid_container][/vc_column][/vc_row]
CONTENT;

$patterns['statistics-2'] = [];
$patterns['statistics-2']['content'] = <<<CONTENT
[vc_row el_class="wpex-pt-60 wpex-pb-30"][vc_column width="1/2"][vcex_heading text="We are the experts in the industry, look no further." tag="h2" font_size="2xl" bottom_margin="20px"][vc_column_text bottom_margin="30px"]We are committed to delivering exceptional value, tailored solutions, and unparalleled service. Our dedicated team ensures your needs are met with expertise, reliability, and a focus on your success.[/vc_column_text][vcex_button font_padding="top:15px|right:25px|bottom:15px|left:25px" color="black" border_radius="0px" text_transform="uppercase" font_weight="500" font_size="sm" letter_spacing="widest"]See Pricing[/vcex_button][/vc_column][vc_column width="1/2"][vcex_grid_container align_items="center" columns_lg="" columns_sm="2"][vcex_milestone style="bordered" padding_all="40px" number="15" caption="Years Experience" caption_size="lg" number_weight="900" caption_font="600" border_color="#A6A6A659"][vcex_milestone style="bordered" padding_all="40px" number="26" caption="Awards Received" caption_size="lg" number_weight="900" caption_font="600" border_color="#A6A6A659"][vcex_milestone style="bordered" padding_all="40px" number="37" caption="Certifications Earned" caption_size="lg" number_weight="900" caption_font="600" border_color="#A6A6A659"][vcex_milestone style="bordered" padding_all="40px" number="70" caption="Projects Completed" caption_size="lg" number_weight="900" caption_font="600" border_color="#A6A6A659"][/vcex_grid_container][/vc_column][/vc_row]
CONTENT;

$patterns['statistics-3'] = [];
$patterns['statistics-3']['content'] = <<<CONTENT
[vc_row full_width="stretch_row" remove_bottom_col_margin="true" wpex_bg_color="#262626" css=".vc_custom_1627248526292{padding-top: 10% !important;padding-bottom: 10% !important;}"][vc_column][vcex_heading text="Project Goals" align="center" tag="h2" font_size="3xl" color="#FFF" text_align="center" bottom_margin="20px"][vc_column_text bottom_margin="50px" color="rgba(255,255,255,0.6)" width="850px" align="center" text_align="center"]Our project goals focus on creating meaningful change and improving lives within our community. We aim to foster compassion, support essential services, and drive sustainable impact. By working together, we bring hope, opportunity, and lasting positive transformation to those in need.[/vc_column_text][vcex_grid_container align_items="center" columns_lg="4" columns_sm="2" gap="30px"][vcex_milestone padding_all="40px" number="16" caption="Years Active" caption_color="#FFF" number_color="#FFF" caption_size="lg" number_weight="400" background_color="#FFFFFF14" number_size="6xl" caption_font="normal"][vcex_milestone padding_all="40px" caption="Money Raised" caption_color="#FFF" number_color="#FFF" caption_size="lg" number_weight="400" background_color="#FFFFFF14" number_size="6xl" caption_font="normal" before="$" after="K"][vcex_milestone padding_all="40px" number="4" caption="People reached" caption_color="#FFF" number_color="#FFF" caption_size="lg" number_weight="400" background_color="#FFFFFF14" number_size="6xl" caption_font="normal" after="M"][vcex_milestone padding_all="40px" number="36" caption="Schools Opened" caption_color="#FFF" number_color="#FFF" caption_size="lg" number_weight="400" background_color="#FFFFFF14" number_size="6xl" caption_font="normal" after="+"][/vcex_grid_container][/vc_column][/vc_row]
CONTENT;

$patterns['statistics-4'] = [];
$patterns['statistics-4']['content'] = <<<CONTENT
[vc_row full_width="stretch_row" content_placement="middle" el_class="wpex-surface-2 wpex-pt-60" column_spacing="60"][vc_column width="1/2"][vcex_heading text="We've come along way, check out our milestones." tag="h2" font_size="3xl" bottom_margin="20px"][vc_column_text bottom_margin="30px"]Look at what we've accomplished—each milestone marks a step forward in our journey, highlighting our growth, dedication, and the positive impact we've made along the way. These achievements are a testament to our commitment and the trust our community has placed in us.[/vc_column_text][vcex_button font_padding="top:15px|right:25px|bottom:15px|left:25px" color="black" font_size="sm" border_radius="0px" text_transform="uppercase" font_weight="500" letter_spacing="widest"]Call to Action[/vcex_button][vcex_spacing size="40px"][/vc_column][vc_column width="1/2"][vcex_grid_container align_items="center" columns_lg="" columns_sm="2" gap="30px"][vcex_milestone padding_all="40px" shadow="shadow-lg" shadow_hover="shadow-xl" number="76" caption="Goals Reached" enable_icon="true" icon_position="top" caption_size="lg" number_weight="600" caption_font="500" classes="wpex-surface-1" after="%" icon="flag" border_radius="10px" icon_size="30px" number_size="4xl"][vcex_milestone padding_all="40px" shadow="shadow-lg" shadow_hover="shadow-xl" number="26" caption="Money Raised" enable_icon="true" icon_position="top" caption_size="lg" number_weight="600" caption_font="500" classes="wpex-surface-1" icon="heart" border_radius="10px" number_size="4xl" icon_size="30px" before="$" after="K"][vcex_milestone padding_all="40px" shadow="shadow-lg" shadow_hover="shadow-xl" number="8" caption="Facebook Likes" enable_icon="true" icon_position="top" caption_size="lg" number_weight="600" caption_font="500" classes="wpex-surface-1" after="M" icon="thumbs-up" border_radius="10px" number_size="4xl" icon_size="30px"][vcex_milestone padding_all="40px" shadow="shadow-lg" shadow_hover="shadow-xl" number="130" caption="Locations Created" enable_icon="true" icon_position="top" caption_size="lg" number_weight="600" caption_font="500" classes="wpex-surface-1" after="+" icon="map-marker" border_radius="10px" number_size="4xl" icon_size="30px"][/vcex_grid_container][/vc_column][/vc_row]
CONTENT;

$patterns['statistics-5'] = [];
$patterns['statistics-5']['content'] = <<<CONTENT
[vc_section el_class="wpex-mt-60"][vc_row][vc_column][vcex_heading text="Our Current Progress" text_align="center" tag="h2" font_size="3xl" bottom_margin="15px"][vc_column_text bottom_margin="10px"width="850px" align="center" text_align="center"]Below is our process, designed to deliver exceptional outcomes through thoughtful planning, collaboration, and innovation. Each step is tailored to ensure we meet your unique needs and exceed expectations.[/vc_column_text][/vc_column][/vc_row][vc_row column_spacing="40"][vc_column width="2/5"][vcex_image source="external" external_image="{$ph_portrait}"][/vc_column][vc_column width="3/5"][vcex_heading text="Projects Completed" bottom_margin="15px" tag="h3" font_size="lg"][vcex_skillbar title="" percentage="36" bottom_margin="15px" box_shadow="false" container_height="20px" percentage_font_size="10px"][vc_column_text bottom_margin="30px"]We've completed 36% of projects ahead of schedule, demonstrating our commitment to efficiency, quality, and exceeding expectations. Each completed project represents our dedication to delivering impactful results and creating lasting value.[/vc_column_text][vcex_heading text="Schools Built" bottom_margin="15px" tag="h3" font_size="lg"][vcex_skillbar title="" percentage="70" bottom_margin="15px" box_shadow="false" container_height="20px" percentage_font_size="10px"][vc_column_text bottom_margin="30px"]We've built 70% of schools in our region, reflecting our commitment to creating educational spaces that empower communities and inspire future generations. Each project stands as a testament to our dedication to excellence and meaningful impact.[/vc_column_text][vcex_heading text="Trademarks Filed" bottom_margin="15px" tag="h3" font_size="lg"][vcex_skillbar title="" percentage="90" bottom_margin="15px" box_shadow="false" container_height="20px" percentage_font_size="10px"][vc_column_text]We've successfully filed 99% of trademarks entrusted to us, ensuring comprehensive protection and support for our clients' brands. Our commitment to accuracy and efficiency helps businesses thrive with confidence.[/vc_column_text][/vc_column][/vc_row][/vc_section]
CONTENT;

$patterns['statistics-6'] = [];
$patterns['statistics-6']['content'] = <<<CONTENT
[vc_row gap="10" el_class="wpex-pt-60"][vc_column width="2/5"][vcex_heading text="My Skills &amp; Talents" tag="h2" font_size="3xl"][vcex_divider_dots align="left" margin="top:15px|bottom:30px" color="currentColor"][vc_column_text bottom_margin="30px"]Explore my skills, highlighting my expertise in web design, user experience, and responsive layouts. I focus on creating visually appealing, functional websites that provide seamless user experiences across all devices.[/vc_column_text][vcex_button]Request a Quote[/vcex_button][/vc_column][vc_column width="3/5"][vcex_skillbar title="HTML" percentage="45" style="alt-1" bottom_margin="20px" border_radius="rounded-full" container_height="20px" percentage_font_size="10px"][vcex_skillbar title="WordPress" percentage="37" style="alt-1" bottom_margin="20px" border_radius="rounded-full" container_height="20px" percentage_font_size="10px"][vcex_skillbar title="Photoshop" percentage="67" style="alt-1" bottom_margin="20px" border_radius="rounded-full" container_height="20px" percentage_font_size="10px"][vcex_skillbar title="SEO &amp; Marketing" percentage="90" style="alt-1" bottom_margin="20px" border_radius="rounded-full" container_height="20px" percentage_font_size="10px"][/vc_column][/vc_row]
CONTENT;

$patterns['statistics-7'] = [];
$patterns['statistics-7']['content'] = <<<CONTENT
[vc_section el_class="wpex-my-60"][vc_row][vc_column][vcex_heading text="With over fifty years of experience we offer unmatched service" font_size="3xl" text_align="center" width="550px" bottom_margin="20px"][vc_column_text bottom_margin="50px" width="700px" text_align="center"]We have built a reputation for delivering exceptional service, combining industry expertise with a commitment to quality and customer satisfaction. Our long-standing success is a testament to our dedication and the trust we’ve earned from clients over the years.[/vc_column_text][vcex_grid_container gap="clamp(30px, 4vw, 50px)"][vcex_teaser heading="100+" text_align="center" heading_size="3xl"]With over 100 successful projects completed, we have consistently delivered exceptional results that exceed expectations.[/vcex_teaser][vcex_teaser heading="24,000+" text_align="center" heading_size="3xl"]With over 24,000 satisfied customers, we’ve built a trusted reputation for delivering high-quality service and lasting relationships.[/vcex_teaser][vcex_teaser heading="$60K" text_align="center" heading_size="3xl"]With over $60K in donations raised, we continue to support meaningful causes and make a lasting impact in our community.[/vcex_teaser][/vcex_grid_container][/vc_column][/vc_row][/vc_section]
CONTENT;

$patterns['statistics-8'] = [];
$patterns['statistics-8']['content'] = <<<CONTENT
[vc_row content_placement="middle" column_spacing="50" el_class="wpex-pt-50"][vc_column width="1/2"][vcex_image source="external" external_image="{$ph_portrait}"][/vc_column][vc_column width="1/2"][vcex_heading text="256" tag="div" font_size="4xl" font_weight="800"][vcex_heading text="Gigabytes of storage" bottom_margin="15px" tag="div" font_size="xl" font_weight="semibold"][vc_column_text]With ample storage capacity, we ensure your data is securely managed and easily accessible, providing reliable performance for all your needs.[/vc_column_text][vcex_divider color="accent" width="50px" align="left" height="4px" margin="top:30px|bottom:30px"][vcex_heading text="12MP" tag="div" font_size="4xl" font_weight="800"][vcex_heading text="Wide-angle and telephoto cameras" bottom_margin="15px" tag="div" font_size="xl" font_weight="semibold"][vc_column_text]The 12MP cameras, featuring both wide-angle and telephoto lenses, deliver exceptional image quality with sharp detail and versatile framing options.[/vc_column_text][vcex_divider color="accent" width="50px" align="left" height="4px" margin="top:30px|bottom:30px"][vcex_heading text="5.8in" tag="div" font_size="4xl" font_weight="800"][vcex_heading text="All-screen OLED Multi-Touch display" bottom_margin="15px" tag="div" font_size="xl" font_weight="semibold"][vc_column_text]The high quality display offers vibrant colors and sharp detail, providing an immersive visual experience in a sleek, compact design.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

$patterns['statistics-9'] = [];
$patterns['statistics-9']['content'] = <<<CONTENT
[vc_row full_width="stretch_row" el_class="wpex-surface-2 wpex-py-60"][vc_column][vcex_heading text="Help us save the rainforest." align="left" float="false" tag="h2" font_size="5xl" width="400px" bottom_margin="40px"][vcex_grid_container gap="60px"][vcex_icon_box heading="30%" style="two" alignment="left" icon="" heading_size="7xl" heading_color="#0c7059"]Forests still cover about 30 percent of the world's land area, but they are disappearing at an alarming rate.[/vcex_icon_box][vcex_icon_box heading="17%" style="two" alignment="left" icon="" heading_size="7xl" heading_color="#0c7059"]Of the Amazonian rainforest has been destroyed over the past 50 years, and losses recently have been on the rise.[/vcex_icon_box][vcex_icon_box heading="80K" style="two" alignment="left" icon="" heading_size="7xl" heading_color="#0c7059"]Most experts agree that we are losing upwards of 80,000 acres of tropical rainforest daily.[/vcex_icon_box][/vcex_grid_container][/vc_column][/vc_row]
CONTENT;

$patterns['statistics-10'] = [];
$patterns['statistics-10']['content'] = <<<CONTENT
[vc_section el_class="wpex-py-60"][vc_row][vc_column][vcex_heading text="Take your business to the next level. See why we stand out from the rest." align="center" font_size="3xl" width="650px" text_align="center"][/vc_column][/vc_row][vc_row remove_bottom_col_margin="true" wpex_border_color="#B5B5B536" css=".vc_custom_1631735211871{margin-bottom: 40px !important;padding-bottom: 30px !important;padding-top: 30px !important;padding-left: 30px !important;padding-right: 30px !important;border-top-width: 3px !important;border-right-width: 3px !important;border-bottom-width: 3px !important;border-left-width: 3px !important;border-left-style: solid !important;border-right-style: solid !important;border-top-style: solid !important;border-bottom-style: solid !important;}"][vc_column width="1/2"][vcex_icon_box heading="87%" style="two" icon="" heading_size="6xl" heading_type="div" heading_weight="bold" wpex_padding="40px"]With an 87% success rate, we consistently deliver outstanding results that drive growth and exceed client expectations.[/vcex_icon_box][vcex_divider color="#fc7f60" height="3px" visibility="visible-phone" width="70%"][vcex_column_side_border background_color="#fc7f60" width="3px"][/vc_column][vc_column width="1/2"][vcex_icon_box heading="300K" style="two" icon="" heading_size="6xl" heading_type="div" heading_weight="bold" wpex_padding="40px"]With over 300K satisfied customers, we've built a reputation for delivering exceptional service and creating lasting relationships.[/vcex_icon_box][/vc_column][/vc_row][vc_row remove_bottom_col_margin="true"][vc_column][vc_column_text width="850px" align="center" text_align="center"]We combine innovative strategies, expert insights, and a commitment to excellence to help your business grow and thrive. Our unique approach ensures that you stand out in a competitive market, delivering results that exceed expectations.[/vc_column_text][/vc_column][/vc_row][/vc_section]
CONTENT;

$patterns['statistics-11'] = [];
$patterns['statistics-11']['content'] = <<<CONTENT
[vc_row remove_bottom_col_margin="true" el_class="wpex-py-60"][vc_column][vcex_heading text="Take your business to the next level. See why we stand out from the rest." font_size="3xl" width="650px" text_align="center" bottom_margin="50px"][vcex_grid_container gap="40px"][vcex_icon_box heading="Daily Visits" style="two" heading_type="h3" icon="area-chart" icon_spacing="25px" wpex_padding="60px" background_color="#b1c7fc" border_radius="10px" heading_size="1em" heading_weight="bold" icon_size="3.8em" font_color="#252c5e" heading_color="#616abe" font_size="2.4em" heading_transform="uppercase" heading_letter_spacing="2px" font_weight="bold" heading_bottom_margin="0px" icon_color="#252c5e"]1,869[/vcex_icon_box][vcex_icon_box heading="Downloads" style="two" heading_type="h3" icon="download" icon_spacing="25px" wpex_padding="60px" background_color="#a0d4ff" border_radius="10px" heading_size="1em" heading_weight="bold" icon_size="3.8em" font_color="#032955" heading_color="#198fdf" font_size="2.4em" heading_transform="uppercase" heading_letter_spacing="2px" font_weight="bold" heading_bottom_margin="0px" icon_color="#032955"]5 Million[/vcex_icon_box][vcex_icon_box heading="Connections" style="two" heading_type="h3" icon="plug" icon_spacing="25px" wpex_padding="60px" background_color="#c3efd7" border_radius="10px" heading_size="1em" heading_weight="bold" icon_size="3.8em" font_color="#013b1d" heading_color="#318859" font_size="2.4em" heading_transform="uppercase" heading_letter_spacing="2px" font_weight="bold" heading_bottom_margin="0px" icon_color="#013b1d"]10,354[/vcex_icon_box][/vcex_grid_container][/vc_column][/vc_row]
CONTENT;

$patterns['statistics-12'] = [];
$patterns['statistics-12']['content'] = <<<CONTENT
[vc_row remove_bottom_col_margin="true" el_class="wpex-py-60"][vc_column][vc_column_text bottom_margin="25px" font_size="sm" text_transform="uppercase" color="accent" font_weight="500" letter_spacing="wider"]About us[/vc_column_text][vc_column_text bottom_margin="60px" font_size="2xl"]We are a dedicated team committed to providing innovative solutions that drive success and create lasting impact. With years of experience and a focus on excellence, we strive to exceed expectations and deliver exceptional value to our clients. [/vc_column_text][vcex_flex_container align_items="center" justify_content="space-between" row_stack_bp="sm" flex_wrap="true" flex_direction="row" gap="40px"][vcex_milestone text_align="left" number="18" caption="Years of experience" caption_size="lg" caption_font="normal" number_weight="500"][vcex_milestone text_align="left" number="74" caption="Established locations" caption_size="lg" caption_font="normal" number_weight="500"][vcex_milestone text_align="left" number="50" caption="Happy customers" caption_size="lg" after="K" caption_font="normal" number_weight="500"][vcex_milestone text_align="left" number="4" caption="Monthly visitors" caption_size="lg" after="M" caption_font="normal" number_weight="500"][/vcex_flex_container][/vc_column][/vc_row]
CONTENT;
// IMPORTANT - Space required to prevent HEREDOC errors.

return $patterns;
