<?php
/**
 * Contact Form Compatibility
 *
 * @author     D-THEMES
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      4.11.0
 */

if ( ! class_exists( 'Alpha_Contact_Form' ) ) {

	/**
	 * Alpha WPForms Class
	 */
	class Alpha_Contact_Form extends Alpha_Base {

		protected $counter;

		/**
		 * Main Class construct
		 *
		 * @since 1.0
		 */
		public function __construct() {
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_style' ), 30 );
		}

		/**
		 * Custom style & script for Contact form 7
		 *
		 * @since 1.0
		 */
		function enqueue_style() {
			wp_deregister_style( 'contact-form-7' );
			wp_dequeue_style( 'contact-form-7' );
			wp_deregister_style( 'contact-form-7-rtl' );
			wp_dequeue_style( 'contact-form-7-rtl' );

			wp_enqueue_style( 'alpha-cf7', alpha_framework_uri( '/plugins/contact-form/contact-form' . ( is_rtl() ? '-rtl' : '' ) . '.min.css' ), array(), ALPHA_VERSION );
		}
	}
}

Alpha_Contact_Form::get_instance();
