<?php
/**
 * WP Rocket Compatibility
 *
 * @author     D-THEMES
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      4.14.0
 */

if ( ! class_exists( 'Alpha_Wp_Rocket' ) ) {

	/**
	 * Alpha WPForms Class
	 */
	class Alpha_Wp_Rocket extends Alpha_Base {

		public function __construct() {
			add_filter( 'rocket_delay_js_exclusions', array( $this, 'delay_js_exclusions' ) );
			add_filter( 'rocket_exclude_defer_js', array( $this, 'defer_js_exclusions' ) );
			add_filter( 'rocket_excluded_inline_js_content', array( $this, 'exclude_inline_js' ) ); // Combine js

			if ( class_exists( 'WooCommerce' ) ) {
				add_filter( 'rocket_cache_reject_uri', array( $this, 'exclude_woo_pages' ) );
			}
		}

		public function exclude_inline_js( $inline_js ): array {
			$inline_js[] = 'webfont-queue';
			return $inline_js;
		}

		public function defer_js_exclusions( $exclude_defer_js ): array {
			$exclude_arr = wp_parse_args(
				$exclude_defer_js,
				array()
			);

			$is_jquery = false;
			if ( wp_script_is( 'isotope-pkgd' ) || wp_script_is( 'alpha-isotope' ) ) {
				$exclude_arr[] = 'alpha-isotope';
				$exclude_arr[] = 'isotope-pkgd';
				$exclude_arr[] = 'imagesloaded';
				$is_jquery     = true;
			}
			if ( wp_script_is( 'alpha-stretch-container' ) ) {
				$exclude_arr[] = 'alpha-stretch-container';
				$is_jquery     = true;
			}
			if ( wp_script_is( 'wc-price-slider' ) ) {
				$exclude_arr[] = 'ui/slider';
				$exclude_arr[] = 'accounting';
				$exclude_arr[] = 'ui/core';
				$exclude_arr[] = 'ui/mouse';
				$exclude_arr[] = 'price-slider';
				$is_jquery     = true;
			}
			if ( $is_jquery ) {
				$exclude_arr[] = '/jquery-?[0-9.]*(.min|.slim|.slim.min)?.js';
			}

			return $exclude_arr;
		}

		public function delay_js_exclusions( $exclude_delay_js ): array {
			$exclude_arr = wp_parse_args(
				$exclude_delay_js,
				array(
					'webfont-queue',
					'browser-config',
					'content-loaded',
				)
			);

			$is_jquery = false;
			if ( wp_script_is( 'alpha-image-compare' ) ) {
				$exclude_arr[] = 'alpha-image-compare';
				$is_jquery     = true;
			}
			if ( wp_script_is( 'alpha-lazyload-delay' ) ) {
				$exclude_arr[] = 'alpha-lazyload-delay';
				$exclude_arr[] = alpha_core_framework_uri( '/addons/lazyload-images/lazyload' . ALPHA_JS_SUFFIX );
				$is_jquery     = true;
			}
			if ( wp_script_is( 'alpha-skeleton' ) ) {
				$exclude_arr[] = alpha_core_framework_uri( '/addons/skeleton/skeleton' . ALPHA_JS_SUFFIX );
				$is_jquery     = true;
			}
			if ( wp_script_is( 'isotope-pkgd' ) || wp_script_is( 'alpha-isotope' ) ) {
				$exclude_arr[] = 'alpha-isotope';
				$exclude_arr[] = 'isotope-pkgd';
				$exclude_arr[] = 'imagesloaded';
				$is_jquery     = true;
			}
			if ( wp_script_is( 'alpha-stretch-container' ) ) {
				$exclude_arr[] = 'alpha-stretch-container';
				$is_jquery     = true;
			}
			if ( wp_script_is( 'wc-price-slider' ) ) {
				$exclude_arr[] = 'ui/slider';
				$exclude_arr[] = 'accounting';
				$exclude_arr[] = 'ui/mouse';
				$exclude_arr[] = 'ui/core';
				$exclude_arr[] = 'price-slider';
				$is_jquery     = true;
			}
			if ( $is_jquery ) {
				$exclude_arr[] = '/jquery-?[0-9.]*(.min|.slim|.slim.min)?.js';
			}

			return $exclude_arr;
		}

		/**
		 * Remove WooCommmerce Pages from WP Rocket cache
		 *
		 * Remove yith scripts
		 *
		 * @since 4.14.0
		 */
		public function exclude_woo_pages( $urls ) {
			$compare_id = wc_get_page_id( 'compare' );
			if ( $compare_id && function_exists( 'get_rocket_i18n_translated_post_urls' ) ) {
				$pattern = '';
				global $wp_rewrite;
				if ( $wp_rewrite->use_trailing_slashes ) {
					$pattern = "?$pattern";
				}

				$compare_url = get_rocket_i18n_translated_post_urls( wc_get_page_id( 'compare' ), 'page', $pattern );
				$urls        = array_merge( $urls, $compare_url );
			}
			return $urls;
		}
	}
}

Alpha_Wp_Rocket::get_instance();
