<?php
/**
 * YITH WooCommerce Wishlist Compatibility
 *
 * @author     D-THEMES
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      4.11.4
 */

if ( ! class_exists( 'Alpha_YITH_WCWL' ) ) {

	/**
	 * Alpha YITH WCWL Class
	 */
	class Alpha_YITH_WCWL extends Alpha_Base {

		/**
		 * Main Class construct
		 */
		public function __construct() {

		}

		/**
		 * Init
		 */
		public function init() {
			add_filter( 'yith_wcwl_custom_css_rules', array( $this, 'custom_css_rules' ), 20 );

			if ( is_admin() && class_exists( 'YITH_WCWL_Rendering_Method_Admin_Handler' ) ) {
				remove_action( 'admin_notices', array( YITH_WCWL_Rendering_Method_Admin_Handler::get_instance(), 'add_notices' ) );
			}

			add_action( 'customize_save_after', array( $this, 'disable_react_rendering_mode' ), 99 );
			add_action( 'alpha_demo_imported', array( $this, 'disable_react_rendering_mode' ) );
		}

		public function custom_css_rules( $rules ) {
			if ( isset( $rules['add_to_wishlist_icon_color'] ) && empty( $rules['add_to_wishlist_icon_color']['value'] ) && null === get_option( 'yith_wcwl_add_to_wishlist_icon_color', null ) ) {
				$rules['add_to_wishlist_icon_color']['value'] = 'currentColor';
			}
			if ( isset( $rules['added_to_wishlist_icon_color'] ) && empty( $rules['added_to_wishlist_icon_color']['value'] ) && null === get_option( 'yith_wcwl_added_to_wishlist_icon_color', null ) ) {
				$rules['added_to_wishlist_icon_color']['value'] = 'currentColor';
			}

			return $rules;
		}

		public function disable_react_rendering_mode() {
			if ( 'php-templates' !== get_option( 'yith_wcwl_rendering_method' ) ) {
				update_option( 'yith_wcwl_rendering_method', 'php-templates' );
			}
		}
	}
}

Alpha_YITH_WCWL::get_instance()->init();
