<?php
/**
 * Alpha Elementor Single Product Notice Widget
 *
 * @author     D-THEMES
 * @package    Alpha Core Framework
 * @subpackage Core
 * @since      1.2
 */
defined( 'ABSPATH' ) || die;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

class Alpha_Single_Product_Notice_Elementor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return ALPHA_NAME . '_sproduct_notice';
	}

	public function get_title() {
		return esc_html__( 'Woo Notices', 'alpha-core' );
	}

	public function get_icon() {
		return 'alpha-elementor-widget-icon eicon-woocommerce-notices';
	}

	public function get_categories() {
		return array( 'alpha_single_product_widget' );
	}

	public function get_keywords() {
		return array( 'single', 'product', 'woocommerce', 'notice', 'notices' );
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Elementor\Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	protected function register_controls() {
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( apply_filters( 'alpha_single_product_builder_set_preview', false ) ) {
			woocommerce_output_all_notices();
			do_action( 'alpha_single_product_builder_unset_preview' );
		}
	}
}
