jQuery(window).on('elementor:init', function ($) {
    var ControlImageChooseItemView = elementor.modules.controls.BaseData.extend({
        ui: function ui() {
            var ui = elementor.modules.controls.BaseData.prototype.ui.apply(this, arguments);
            ui.inputs = '[type="radio"]';
            return ui;
        },
        events: function events() {
            return _.extend(elementor.modules.controls.BaseData.prototype.events.apply(this, arguments), {
                'mousedown label': 'onMouseDownLabel',
                'click @ui.inputs': 'onClickInput',
                'change @ui.inputs': 'onBaseInputChange'
            });
        },
        updatePlaceholder: function updatePlaceholder() {
            var placeholder = this.getControlPlaceholder();
            if (!this.getControlValue() && placeholder) {
                // Find the input which has value equals to the placeholder (which is the parent's value),
                // and add it a placeholder class, to indicate which value is selected in the parent.
                this.ui.inputs.filter("[value=\"".concat(this.getControlPlaceholder(), "\"]")).addClass('e-choose-placeholder');
            } else {
                this.ui.inputs.removeClass('e-choose-placeholder');
            }
        },
        onReady: function onReady() {
            this.updatePlaceholder();
        },
        applySavedValue: function applySavedValue() {
            var currentValue = this.getControlValue();
            if (currentValue) {
                this.ui.inputs.filter('[value="' + currentValue + '"]').prop('checked', true);
            } else {
                this.ui.inputs.filter(':checked').prop('checked', false);
            }
        },
        onMouseDownLabel: function onMouseDownLabel(event) {
            var $clickedLabel = this.$(event.currentTarget),
                $selectedInput = this.$('#' + $clickedLabel.attr('for'));
            $selectedInput.data('checked', $selectedInput.prop('checked'));
        },
        onClickInput: function onClickInput(event) {
            if (!this.model.get('toggle')) {
                return;
            }
            var $selectedInput = this.$(event.currentTarget);
            if ($selectedInput.data('checked')) {
                $selectedInput.prop('checked', false).trigger('change');
            }
        },
        onBaseInputChange: function onBaseInputChange() {
            elementor.modules.controls.BaseData.prototype.onBaseInputChange.apply(this, arguments);
            this.updatePlaceholder();
        }
    }, {
        onPasteStyle: function onPasteStyle(control, clipboardValue) {
            return '' === clipboardValue || undefined !== control.options[clipboardValue];
        }
    });
    elementor.addControlView('image_choose', ControlImageChooseItemView);
});
