<?php
defined( 'ABSPATH' ) || die;

/**
 * Entrance Animation Functions
 *
 * @author     D-THEMES
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @since      1.3
 */

use Elementor\Controls_Manager;

/**
 * Register motion effect controls for group widgets such as counters, testimonials etc.
 *
 * @since 1.3
 */
if ( ! function_exists( 'alpha_elementor_animations_layout_controls' ) ) {
	function alpha_elementor_animations_layout_controls( $self, $section = false, $image_widget = false ) {
		if ( $section ) {
			$self->start_controls_section(
				'section_items_e_animations',
				array(
					'label' => esc_html__( 'Entrance Animations', 'alpha-core' ),
					'tab'   => Controls_Manager::TAB_CONTENT,
				)
			);
		}

		$animations = alpha_get_animations( 'in' );
		if ( $image_widget ) {
			$animations = array_merge(
				$animations,
				array(
					'scaleRevealInDown'  => esc_html__( 'Scale & Reveal In Down', 'alpha-core' ),
					'scaleRevealInLeft'  => esc_html__( 'Scale & Reveal In Left', 'alpha-core' ),
					'scaleRevealInRight' => esc_html__( 'Scale & Reveal In Right', 'alpha-core' ),
					'scaleRevealInUp'    => esc_html__( 'Scale & Reveal In Up', 'alpha-core' ),
				)
			);
		}

			$self->add_control(
				'item_animation',
				$section ? array(
					'type'        => Elementor\Controls_Manager::SELECT,
					'label'       => esc_html__( 'Entrance Animation', 'alpha-core' ),
					'description' => esc_html__( 'Controls the animation effect of individual item in this group widget.', 'alpha-core' ),
					'options'     => $animations,
					'default'     => 'none',
					'render_type' => 'template',
				) : array(
					'type'        => Elementor\Controls_Manager::SELECT,
					'label'       => esc_html__( 'Entrance Animation', 'alpha-core' ),
					'description' => esc_html__( 'Controls the animation effect of individual item in this group widget.', 'alpha-core' ),
					'options'     => $animations,
					'default'     => 'none',
					'render_type' => 'template',
					'separator'   => 'before',
				)
			);

		if ( ALPHA_NAME . '_widget_posts_grid' == $self->get_name() ) {
			$self->add_control(
				'notice_button_link',
				array(
					'type'            => Controls_Manager::RAW_HTML,
					'raw'             => sprintf( esc_html__( 'This animation works with only featured images. You should select one of post layouts except Default %1$shere%2$s.', 'alpha-core' ), '<a href="#" class="switch-section-link" data-tab="content" data-section="section_selector" data-control="builder_id"><b>', '</b></a>' ),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
					'condition'       => array(
						'item_animation' => array( 'scaleRevealInDown', 'scaleRevealInUp', 'scaleRevealInLeft', 'scaleRevealInRight' ),
						'builder_id'     => '',
					),
				)
			);
		}

			$self->add_control(
				'item_reveal_effect_color',
				array(
					'label'       => esc_html__( 'Animation Color', 'alpha-core' ),
					'description' => esc_html__( 'Controls the color of the reveal animation.', 'alpha-core' ),
					'type'        => Controls_Manager::COLOR,
					'condition'   => array(
						'item_animation' => array( 'revealInDown', 'revealInLeft', 'revealInRight', 'revealInUp' ),
					),
					'selectors'   => array(
						'{{WRAPPER}} [class*="reveal"]' => '--alpha-reveal-animation-color: {{VALUE}};',
					),
				),
			);

			$self->add_control(
				'item_animation_duration',
				array(
					'label'        => esc_html__( 'Animation Duration', 'alpha-core' ),
					'type'         => Controls_Manager::SELECT,
					'default'      => '',
					'options'      => array(
						'slow' => esc_html__( 'Slow', 'alpha-core' ),
						''     => esc_html__( 'Normal', 'alpha-core' ),
						'fast' => esc_html__( 'Fast', 'alpha-core' ),
					),
					'prefix_class' => 'animated-',
					'condition'    => array(
						'item_animation!' => 'none',
					),
					'render_type'  => 'template',
				)
			);

			$self->add_control(
				'item_animation_delay',
				array(
					'label'       => esc_html__( 'Animation Delay', 'alpha-core' ) . ' (ms)',
					'type'        => Controls_Manager::NUMBER,
					'default'     => 200,
					'min'         => 0,
					'step'        => 100,
					'condition'   => array(
						'item_animation!' => 'none',
					),
					'render_type' => 'template',
				)
			);

		if ( $section ) {
			$self->end_controls_section();
		}
	}
}

if ( ! function_exists( 'alpha_get_items_animation_data' ) ) {
	function alpha_get_items_animation_data( $settings ) {
		$data = array(
			'class'         => '',
			'data-settings' => '',
		);
		if ( ! empty( $settings['item_animation'] ) && 'none' != $settings['item_animation'] ) {
			$data['class'] = 'appear-animate';
			if ( $settings['item_animation_duration'] ) {
				$data['class'] .= ' animated-' . $settings['item_animation_duration'];
			}
			$data['data-settings'] = array(
				'_animation' => $settings['item_animation'],
			);
			if ( $settings['item_animation_delay'] ) {
				$data['data-settings']['_animation_delay'] = $settings['item_animation_delay'];
			}
		}
		return $data;
	}
}

if ( ! function_exists( 'alpha_elementor_items_animation_template' ) ) {
	function alpha_elementor_items_animation_template() {
		?>
		function alpha_get_items_animation_data( settings ) {
			var result = {
				class: '',
				settings: '',
			};
			if ( settings['item_animation'] && 'none' != settings['item_animation'] ) {
				result.class = 'appear-animate';
				if ( settings['item_animation_duration'] ) {
					result.class += ' animated-' + settings['item_animation_duration'];
				}
				result.settings = {
					_animation: settings['item_animation'],
				};
				if ( settings['item_animation_delay'] ) {
					result.settings._animation_delay = settings['item_animation_delay'];
				}
			}

			return result;
		}
		<?php
	}
}
